% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moment_match.R
\name{moment_match.CmdStanFit}
\alias{moment_match.CmdStanFit}
\title{Generic importance weighted moment matching algorithm for
\code{CmdStanFit} objects.  See additional arguments from
\code{moment_match.matrix}}
\usage{
\method{moment_match}{CmdStanFit}(
  x,
  log_prob_target_fun = NULL,
  log_ratio_fun = NULL,
  constrain_draws = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted \code{CmdStanFit} object.}

\item{log_prob_target_fun}{Log density of the target.  The function
takes argument \code{draws}, which are the unconstrained draws.}

\item{log_ratio_fun}{Log of the density ratio (target/proposal).
The function takes argument \code{draws}, which are the unconstrained
draws.}

\item{constrain_draws}{Logical specifying whether to return draws on the
constrained space. Draws are also constrained for computing expectations. Default is TRUE.}

\item{...}{Further arguments passed to \code{moment_match.matrix}.}
}
\value{
Returns a list with 3 elements: transformed draws, updated
importance weights, and the pareto k diagnostic value.
}
\description{
Generic importance weighted moment matching algorithm for
\code{CmdStanFit} objects.  See additional arguments from
\code{moment_match.matrix}
}
