% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consume.R
\name{nth}
\alias{nth}
\title{Returns the nth item of an iteror}
\usage{
nth(obj, n, or, ...)
}
\arguments{
\item{obj}{an iterable.}

\item{n}{The index of the desired element to return.}

\item{or}{If the iteror finishes before retuning \code{n} elements,
this argument will be forced and returned.}

\item{...}{passed along to \link{iteror} constructor.}
}
\value{
The nth element of the iteror or the result of forcing \code{or}.
}
\description{
Returns the \code{n}th item of an \code{iteror} after advancing the
iteror \code{n} steps ahead. If the \code{iteror} is entirely consumed,
the argument \code{or} is returned instead. That is, if either \code{n >
length(iteror)} or \code{n} is 0, then the \code{iteror} is consumed.
}
\examples{
it <- iteror(1:10)
# Returns 5
nth(it, 5, NA)

it2 <- iteror(letters)
# Returns 'e'
nth(it2, 5, NA)

it3 <- iteror(letters)
# Returns default value of NA
nth(it3, 42, NA)

it4 <- iteror(letters)
# Returns default value of "foo"
nth(it4, 42, or="foo")
}
\seealso{
take consume collect
}
