% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itee.R
\name{i_tee}
\alias{i_tee}
\title{Create multiple iterators from one source}
\usage{
i_tee(obj, n, max = 2^16 - 1, ...)
}
\arguments{
\item{obj}{an iterable object}

\item{n}{the number of iterators to return}

\item{max}{The maximum number of values to buffer.}

\item{...}{passed along to \code{iteror(obj, ...)}}
}
\value{
a list of \code{n} iterators.
}
\description{
\code{i_tee(obj, n)} consumes and buffers the output of a single iterator
\code{obj} so that it can be read by \code{n} independent sub-iterators.
}
\details{
It works by saving the output of source \code{obj} in a queue, while
each sub-iterator has a "read pointer" indexing into the
queue. Items are dropped from the queue after all sub-iterators
have seen them.

This means that if one sub-iterator falls far behind the others, or
equivalently if one sub-iterator reads far ahead its cohort the
others, the intervening values will be kept in memory. The \code{max}
argument gives a limit on how many items will be held. If this
limit is exceeded due to one sub-iterator reading far ahead of the
others, an error will be thrown when that sub-iterator attempts to
read a new value.
}
\author{
Peter Meilstrup
}
