% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipwCoxInd.R
\name{ipwCoxInd}
\alias{ipwCoxInd}
\title{Inference of marginal HR in IPW Cox model based on CSV without clustering (i.e., assuming independence among observations)}
\usage{
ipwCoxInd(data, indA, indX, indStatus, indTime, ties = "breslow",
  confidence = 0.95)
}
\arguments{
\item{data}{A dataset to be analyzed in the form of R data frame.}

\item{indA}{A column name indicating the treatment variable.}

\item{indX}{A vector of column names indicating the covariates included in the propensity score model.}

\item{indStatus}{A column name indicating the non-censoring status (1 if observed and 0 if censored).}

\item{indTime}{A column name indicating the outcome variable, i.e., min(true event time, censoring time).}

\item{ties}{A character string indicating the method ("efron","breslow",or "exact") to deal with tied events for point estimation; the default is "breslow". For variance estimation, Breslow method is used to deal with tied events.}

\item{confidence}{A confidence level between 0 and 1; the default is 0.95 corresponding to a 95 per cent confidence interval.}
}
\value{
A matrix of inference results from inverse probability weighted Cox model with independent sample. The first and the second rows report log marginal hazard ratio estimate and associated corrected sandwich based standard error, marginal hazard ratio estimate and associated normality-based confidence interval, under conventional inverse probability weights and stabilized weights, respectively.
}
\description{
Inference of marginal hazard ratios (HR) in inverse probability weighted (IPW) Cox model with independent sample (i.e, without clustered data), under both the conventional inverse probability weights and the stabilized weights. Corrected sandwich variance (CSV) estimation method is used for variance estimation of estimated log marginal hazard ratios.
}
\examples{
#simulate a dataset under marginal hazard ratio 1.5 without clustering
set.seed(100)
n=700
T0=rexp(n, rate=0.01)
ZZZ=rnorm(n)
X1= 0.5*(T0+0.2)/(T0+1)+0.3*ZZZ
X2= 1/log(1.3*T0+3)-0.3*ZZZ
X3= rbinom(n,1,0.3+0.5/(T0+1))  
A=rbinom(n,1,1/(1+exp(0.53+X1-X2-X3)))
Ttime <- T0*exp(-log(1.5)*A)
rateC=0.0005
C <- rexp(n, rate=rateC)
time <- pmin(Ttime, C)
status <- as.numeric(Ttime <= C)
da=data.frame(id=1:n,time=time,status=status,A=A,X1=X1,X2=X2,X3=X3)
head(da)
#inference results for marginal hazard ratio  
ipwCoxInd(data=da,indA="A",indX=c("X1","X2","X3"),indStatus="status",indTime="time")

}
