% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{ipums_callback}
\alias{ipums_callback}
\alias{IpumsChunkCallback}
\alias{IpumsSideEffectCallback}
\alias{IpumsDataFrameCallback}
\alias{IpumsListCallback}
\alias{IpumsBiglmCallback}
\title{Callback classes}
\description{
These classes are used to define callback behaviors for use with
\code{\link[=read_ipums_micro_chunked]{read_ipums_micro_chunked()}}. They are based on the
\code{\link[readr:callback]{callback}} classes from readr, but
have been adapted to include handling of implicit decimal values and
variable/value labeling for use with IPUMS microdata extracts.
}
\details{
\describe{
\item{IpumsSideEffectCallback}{
Callback function that is used only for side effects, no results are
returned.

Initialize with a function that takes 2 arguments. The first argument
(\code{x}) should correspond to the data chunk and the second (\code{pos})
should correspond to the position of the first observation in the chunk.

If the function returns \code{FALSE}, no more chunks will be read.
}
\item{IpumsDataFrameCallback}{
Callback function that combines the results from each chunk into a
single output \code{data.frame} (or similar) object.

Initialize the same way as you would \code{IpumsSideEffectCallback}. The
provided function should return an object that inherits from \code{data.frame}.

The results from each application of the callback function will be
added to the output \code{data.frame}.
}
\item{IpumsListCallback}{
Callback function that returns a list, where each element contains the
result from a single chunk.

Initialize the same was as you would \code{IpumsSideEffectCallback}.
}
\item{IpumsBiglmCallback}{
Callback function that performs a linear regression on a dataset by chunks
using the biglm package.

Initialize with a function that takes 2 arguments: The first argument
should correspond to a \link[stats:formula]{formula} specifying the regression
model. The second should correspond to a function that prepares the data
before running the regression analysis. This function follows the
conventions of the functions used in other callbacks. Any additional
arguments passed to this function are passed to biglm.
}
\item{IpumsChunkCallback}{
(Advanced) Callback interface definition. All
callback functions for IPUMS data should inherit from this class, and
should use private method \code{ipumsify} on the data to handle implicit
decimals and value labels.
}
}
}
\keyword{internal}
