/*
       NOTE: You need to edit the `libname` command to specify the path to the directory
       where the data file is located. For example: "C:ipums_directory".
       Edit the `filename` command similarly to include the full path (the directory and the data file name).
    */
libname TERRAPOP ".";
 filename ASCIIDAT "terrapop_extract_3485.csv";
proc format cntlout = TERRAPOP.terrapop_extract_3485_f;
run;
data TERRAPOP.terrapop_extract_3485;
 infile ASCIIDAT dlm = "," firstobs = 2;
input
EDUCYEARS_NP_FLAD_NP81_TP GEOG_CODE GEOG_CODE_LABEL LCSNOWICE_PERCENT_AREA_BIN_NP_FLAD_GLC2000
;
label
EDUCYEARS_NP_FLAD_NP81_TP = "Mean years of schooling completed by persons age 25+"
GEOG_CODE = "Geog instance code"
GEOG_CODE_LABEL = "Geog instance label"
LCSNOWICE_PERCENT_AREA_BIN_NP_FLAD_GLC2000 = "LCSNOWICE_percent_area_bin_NP_FLAD_GLC2000"
;
EDUCYEARS_NP_FLAD_NP81_TP    EDUCYEARS_NP_FLAD_NP81_TP_f.
GEOG_CODE    GEOG_CODE_f.
GEOG_CODE_LABEL    GEOG_CODE_LABEL_f.
LCSNOWICE_PERCENT_AREA_BIN_NP_FLAD_GLC2000    LCSNOWICE_PERCENT_AREA_BIN_NP_FLAD_GLC2000_f.
;
format
EDUCYEARS_NP_FLAD_NP81_TP  10
GEOG_CODE  10
GEOG_CODE_LABEL  32
LCSNOWICE_PERCENT_AREA_BIN_NP_FLAD_GLC2000  10
;
run;
proc print data = TERRAPOP.terrapop_extract_3485;
run;
