% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_cmdstan_exists.R
\name{stan_cmdstan_exists}
\alias{stan_cmdstan_exists}
\title{Check if \code{instantiate} can find CmdStan.}
\usage{
stan_cmdstan_exists(cmdstan_install = Sys.getenv("CMDSTAN_INSTALL"))
}
\arguments{
\item{cmdstan_install}{Character of length 1, how CmdStan was installed. The
installation method determines how \code{instantiate} looks up CmdStan.
Set the default value with the \code{CMDSTAN_INSTALL} environment variable.
Choices:
\enumerate{
\item \code{"internal"}: Use the copy of CmdStan installed internally inside the
\code{instantiate} package file system. Before using this option,
CmdStan must be installed in the package file system. To do this,
set the \code{CMDSTAN_INSTALL} environment variable to \code{"internal"} before
installing \code{instantiate}.
\item \code{"fixed"}: Use the copy of CmdStan that was located at the value
contained in \code{Sys.getenv("CMDSTAN")} at the time \code{instantiate}
was installed. In this case, the path to CmdStan is not inside
\code{instantiate} itself, but it is fixed at installation time
and does not depend on the current value of
\code{Sys.getenv("CMDSTAN")} at runtime.
\item \code{"cmdstanr"}: Let the \code{cmdstanr::cmdstan_path()} decide where
to look for CmdStan. The \code{cmdstanr} package must be installed. If it
is not installed, the function returns the empty string \code{""}.
\item \code{""} (default): Try all 3 options in the order above to find a valid
installed copy of CmdStan.
}}
}
\value{
\code{TRUE} if \code{instantiate} can find CmdStan, \code{FALSE} otherwise.
}
\description{
Check if \code{instantiate} can find CmdStan.
}
\examples{
stan_cmdstan_exists()
}
\seealso{
Other cmdstan: 
\code{\link{stan_cmdstan_version}()}
}
\concept{cmdstan}
