% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim_hmm}
\alias{sim_hmm}
\title{Simulate a time series from a Gaussian-hidden Markov model}
\usage{
sim_hmm(T, N, theta)
}
\arguments{
\item{T}{An \code{integer}, the number of observations.}

\item{N}{An \code{integer}, the number of states.}

\item{theta}{A \code{numeric} vector of model parameters.
\itemize{
\item The first \code{N*(N-1)} elements are the logarithms of the non-diagonal
elements of the transition probability matrix.
\item The next \code{N} elements are the mean values of the state-dependent
normal distributions.
\item The last \code{N} elements are the logarithms of the standard deviations of
the state-dependent normal distributions.
}}
}
\value{
A \code{numeric} vector, the simulated time series.
}
\description{
Simulate a time series from a Gaussian-hidden Markov model
}
\examples{
tpm <- matrix(c(0.8,0.1,0.2,0.9), nrow = 2)
mu <- c(-2,2)
sigma <- c(0.5,1)
theta <- c(log(tpm[row(tpm) != col(tpm)]), mu, log(sigma))
data <- sim_hmm(T = 100, N = 2, theta = theta)
plot(data, type = "l")

}
\seealso{
\code{\link[=f_ll_hmm]{f_ll_hmm()}} for computing the log-likelihood of a Gaussian-hidden Markov
model
}
\keyword{function}
