% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout.davidson.harel}
\alias{layout.davidson.harel}
\title{The Davidson-Harel layout algorithm}
\usage{
layout.davidson.harel(
  graph,
  coords = NULL,
  maxiter = 10,
  fineiter = max(10, log2(vcount(graph))),
  cool.fact = 0.75,
  weight.node.dist = 1,
  weight.border = 0,
  weight.edge.lengths = edge_density(graph)/10,
  weight.edge.crossings = 1 - sqrt(edge_density(graph)),
  weight.node.edge.dist = 0.2 * (1 - edge_density(graph))
)
}
\arguments{
\item{graph}{The graph to lay out. Edge directions are ignored.}

\item{coords}{Optional starting positions for the vertices. If this argument
is not \code{NULL} then it should be an appropriate matrix of starting
coordinates.}

\item{maxiter}{Number of iterations to perform in the first phase.}

\item{fineiter}{Number of iterations in the fine tuning phase.}

\item{cool.fact}{Cooling factor.}

\item{weight.node.dist}{Weight for the node-node distances component of the
energy function.}

\item{weight.border}{Weight for the distance from the border component of
the energy function. It can be set to zero, if vertices are allowed to sit
on the border.}

\item{weight.edge.lengths}{Weight for the edge length component of the
energy function.}

\item{weight.edge.crossings}{Weight for the edge crossing component of the
energy function.}

\item{weight.node.edge.dist}{Weight for the node-edge distance component of
the energy function.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{layout.davidson.harel()} was renamed to \code{layout_with_dh()} to create a more
consistent API.
}
\keyword{internal}
