% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{rep.igraph}
\alias{rep.igraph}
\alias{*.igraph}
\title{Replicate a graph multiple times}
\usage{
\method{rep}{igraph}(x, n, mark = TRUE, ...)

\method{*}{igraph}(x, n)
}
\arguments{
\item{x}{The input graph.}

\item{n}{Number of times to replicate it.}

\item{mark}{Whether to mark the vertices with a \code{which} attribute,
an integer number denoting which replication the vertex is coming
from.}

\item{...}{Additional arguments to satisfy S3 requirements,
currently ignored.}
}
\description{
The new graph will contain the input graph the given number
of times, as unconnected components.
}
\examples{
rings <- make_ring(5) * 5
}
\seealso{
Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()},
\code{\link{vertex}()}

Other functions for manipulating graph structure: 
\code{\link{+.igraph}()},
\code{\link{add_edges}()},
\code{\link{add_vertices}()},
\code{\link{complementer}()},
\code{\link{compose}()},
\code{\link{connect}()},
\code{\link{contract}()},
\code{\link{delete_edges}()},
\code{\link{delete_vertices}()},
\code{\link{difference}()},
\code{\link{difference.igraph}()},
\code{\link{disjoint_union}()},
\code{\link{edge}()},
\code{\link{igraph-minus}},
\code{\link{intersection}()},
\code{\link{intersection.igraph}()},
\code{\link{path}()},
\code{\link{permute}()},
\code{\link{reverse_edges}()},
\code{\link{simplify}()},
\code{\link{union}()},
\code{\link{union.igraph}()},
\code{\link{vertex}()}
}
\concept{functions for manipulating graph structure}
