## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 7, fig.height = 5
)


## ----oandaswitch--------------------------------------------------------------
library(ichimoku)

oanda_switch()

## ----oanda, eval=FALSE--------------------------------------------------------
#  oanda("USD_JPY", count = 3, from = "2010-11-01", price = "B")
#  #>                  time   open   high    low  close volume complete
#  #> 1 2010-11-01 21:00:00 80.275 81.504 80.225 80.501  22291     TRUE
#  #> 2 2010-11-02 21:00:00 80.504 80.956 80.460 80.617  13795     TRUE
#  #> 3 2010-11-03 21:00:00 80.632 81.585 80.594 81.069  22204     TRUE

## ----oandac, eval=FALSE-------------------------------------------------------
#  # For a live Palladium price chart:
#  oanda_chart("XPD_USD")

## ----oandacs, eval=FALSE------------------------------------------------------
#  # To access the data, simply assign the return value to an object:
#  cloud <- oanda_chart("XPD_USD")

## ----oandas, eval=FALSE-------------------------------------------------------
#  oanda_studio()

## ----archive, eval=FALSE------------------------------------------------------
#  # Supply the quoted file path / name, for example:
#  cloud <- archive("~/Downloads/SUGAR_USD_D_A.rda")
#  
#  # Or alternatively, choose the saved file interactively using a system dialog:
#  cloud <- archive()

## ----oandastream, eval=FALSE--------------------------------------------------
#  # Streaming session will end with data automatically returned after 600 secs (10 mins):
#  data <- oanda_stream("UK10YB_GBP", limit = 600)
#  #> Streaming data... Press 'Esc' to return
#  #>                   time           bids           asks closeoutBid closeoutAsk    status tradeable instrument
#  #> 1  2022-11-15 11:04:00 105.049, 10000 105.079, 10000     105.049     105.079 tradeable      TRUE UK10YB_GBP
#  #> 2  2022-11-15 11:04:01 105.039, 10000 105.079, 10000     105.039     105.079 tradeable      TRUE UK10YB_GBP
#  #> 3  2022-11-15 11:04:01 105.049, 10000 105.079, 10000     105.049     105.079 tradeable      TRUE UK10YB_GBP
#  #> 4  2022-11-15 11:04:04 105.059, 10000 105.089, 10000     105.059     105.089 tradeable      TRUE UK10YB_GBP
#  #> 5  2022-11-15 11:04:10 105.059, 10000 105.089, 10000     105.059     105.089 tradeable      TRUE UK10YB_GBP
#  #> 6  2022-11-15 11:04:11 105.059, 10000 105.089, 10000     105.059     105.089 tradeable      TRUE UK10YB_GBP
#  #> 7  2022-11-15 11:04:15 105.049, 10000 105.089, 10000     105.049     105.089 tradeable      TRUE UK10YB_GBP
#  #> 8  2022-11-15 11:04:15 105.049, 10000 105.079, 10000     105.049     105.079 tradeable      TRUE UK10YB_GBP

## ----oandaq, eval = FALSE-----------------------------------------------------
#  oanda_quote("USD_JPY")
#  #> USD_JPY 2021-10-05 16:29:44 open: 110.931  high: 111.564  low: 110.871  last: 111.398  %chg: 0.421 M

## ----oandav, eval = FALSE-----------------------------------------------------
#  oanda_view()
#  Enter market [a]llfx [b]onds [c]ommodities [f]x [m]etals [s]tocks: c
#  #> Retrieving commodities [..........]
#  #> 2021-12-11 01:58:21 / M
#  #>                  open      high        low       last    %chg
#  #> NATGAS_USD    3.76200    3.9260    3.72400    3.85200  2.3923
#  #> BCO_USD      74.52600   76.2310   74.32600   75.88000  1.8168
#  #> WTICO_USD    70.91200   72.5540   70.55400   72.19000  1.8022
#  #> WHEAT_USD     7.67200    7.7710    7.57100    7.72700  0.7169
#  #> XPT_USD     930.20200  939.6000  924.29400  936.43800  0.6704
#  #> SOYBN_USD    12.63500   12.7580   12.58800   12.67800  0.3403
#  #> SUGAR_USD     0.19274    0.1948    0.19176    0.19334  0.3113
#  #> CORN_USD      5.89800    5.9410    5.86800    5.90200  0.0678
#  #> XCU_USD       4.30292    4.3479    4.26536    4.28361 -0.4488
#  #> XPD_USD    1805.14800 1815.1260 1729.61100 1752.81200 -2.8993

## ----oandapos, eval=FALSE-----------------------------------------------------
#  df <- oanda_positions("GBP_JPY")

## ----oandaposchart, echo=FALSE------------------------------------------------
df <- structure(list(price = c(124.75, 124.85, 124.9, 124.95, 125.05, 
125.2, 125.25, 125.3, 125.35, 125.4, 125.5, 125.6, 125.7, 125.85, 
126, 126.2, 126.4, 126.5, 126.55, 126.65, 126.7, 126.75, 126.85, 
126.9, 126.95, 127, 127.05, 127.1, 127.15, 127.2, 127.25, 127.3, 
127.35, 127.4, 127.45, 127.5, 127.55, 127.6, 127.65, 127.7, 127.75, 
127.85, 127.9, 127.95, 128, 128.05, 128.1, 128.15, 128.2, 128.25, 
128.3, 128.35, 128.4, 128.45, 128.5, 128.55, 128.6, 128.65, 128.7, 
128.75, 128.8, 128.85, 128.9, 128.95, 129, 129.05, 129.1, 129.15, 
129.2, 129.25, 129.3, 129.35, 129.4, 129.45, 129.5, 129.55, 129.6, 
129.65, 129.7, 129.75, 129.8, 129.85, 129.9, 129.95, 130, 130.05, 
130.1, 130.15, 130.2, 130.25, 130.3, 130.35, 130.4, 130.45, 130.5, 
130.55, 130.6, 130.65, 130.7, 130.75, 130.8, 130.85, 130.9, 130.95, 
131, 131.05, 131.1, 131.15, 131.2, 131.25, 131.3, 131.35, 131.4, 
131.45, 131.5, 131.55, 131.6, 131.65, 131.7, 131.75, 131.8, 131.85, 
131.9, 131.95, 132, 132.05, 132.1, 132.15, 132.2, 132.25, 132.3, 
132.35, 132.4, 132.45, 132.5, 132.55, 132.6, 132.65, 132.7, 132.75, 
132.8, 132.85, 132.9, 132.95, 133, 133.05, 133.1, 133.15, 133.2, 
133.25, 133.3, 133.35, 133.4, 133.45, 133.5, 133.55, 133.6, 133.65, 
133.7, 133.75, 133.8, 133.85, 133.9, 133.95, 134, 134.05, 134.1, 
134.15, 134.2, 134.25, 134.3, 134.35, 134.4, 134.45, 134.5, 134.55, 
134.6, 134.65, 134.7, 134.75, 134.8, 134.85, 134.9, 134.95, 135, 
135.05, 135.1, 135.15, 135.2, 135.25, 135.3, 135.35, 135.4, 135.45, 
135.5, 135.55, 135.6, 135.65, 135.7, 135.75, 135.8, 135.85, 135.9, 
135.95, 136, 136.05, 136.1, 136.15, 136.2, 136.25, 136.3, 136.35, 
136.4, 136.45, 136.5, 136.55, 136.6, 136.65, 136.7, 136.75, 136.8, 
136.85, 136.9, 136.95, 137, 137.05, 137.1, 137.15, 137.2, 137.25, 
137.3, 137.35, 137.4, 137.45, 137.5, 137.55, 137.6, 137.65, 137.7, 
137.75, 137.8, 137.85, 137.9, 137.95, 138, 138.05, 138.1, 138.15, 
138.2, 138.25, 138.3, 138.35, 138.4, 138.45, 138.5, 138.55, 138.6, 
138.65, 138.7, 138.75, 138.8, 138.85, 138.9, 138.95, 139, 139.05, 
139.1, 139.15, 139.2, 139.25, 139.3, 139.35, 139.4, 139.45, 139.5, 
139.55, 139.6, 139.65, 139.7, 139.75, 139.8, 139.85, 139.9, 139.95, 
140, 140.05, 140.1, 140.15, 140.2, 140.25, 140.3, 140.35, 140.4, 
140.45, 140.5, 140.55, 140.6, 140.65, 140.7, 140.75, 140.8, 140.85, 
140.9, 140.95, 141, 141.05, 141.1, 141.15, 141.2, 141.25, 141.3, 
141.35, 141.4, 141.45, 141.5, 141.55, 141.6, 141.65, 141.7, 141.75, 
141.8, 141.85, 141.9, 141.95, 142, 142.05, 142.1, 142.15, 142.2, 
142.25, 142.3, 142.35, 142.4, 142.45, 142.5, 142.55, 142.6, 142.65, 
142.7, 142.75, 142.8, 142.85, 142.9, 142.95, 143, 143.05, 143.1, 
143.15, 143.2, 143.25, 143.3, 143.35, 143.4, 143.45, 143.5, 143.55, 
143.6, 143.65, 143.7, 143.75, 143.8, 143.85, 143.9, 143.95, 144, 
144.05, 144.1, 144.15, 144.2, 144.25, 144.3, 144.35, 144.4, 144.45, 
144.5, 144.55, 144.6, 144.65, 144.7, 144.75, 144.8, 144.85, 144.9, 
144.95, 145, 145.05, 145.1, 145.15, 145.2, 145.25, 145.3, 145.35, 
145.4, 145.45, 145.5, 145.55, 145.6, 145.65, 145.7, 145.75, 145.8, 
145.85, 145.9, 145.95, 146, 146.05, 146.1, 146.15, 146.2, 146.25, 
146.3, 146.35, 146.4, 146.45, 146.5, 146.55, 146.6, 146.65, 146.7, 
146.75, 146.8, 146.85, 146.9, 146.95, 147, 147.05, 147.1, 147.15, 
147.2, 147.25, 147.3, 147.35, 147.4, 147.45, 147.5, 147.55, 147.6, 
147.65, 147.7, 147.75, 147.8, 147.85, 147.9, 147.95, 148, 148.05, 
148.1, 148.15, 148.2, 148.25, 148.3, 148.35, 148.4, 148.45, 148.5, 
148.55, 148.6, 148.65, 148.7, 148.75, 148.8, 148.85, 148.9, 148.95, 
149, 149.05, 149.1, 149.15, 149.2, 149.25, 149.3, 149.35, 149.4, 
149.45, 149.5, 149.55, 149.6, 149.65, 149.7, 149.75, 149.8, 149.85, 
149.9, 149.95, 150, 150.05, 150.1, 150.15, 150.2, 150.25, 150.3, 
150.35, 150.4, 150.45, 150.5, 150.55, 150.6, 150.65, 150.7, 150.75, 
150.8, 150.85, 150.9, 150.95, 151, 151.05, 151.1, 151.15, 151.2, 
151.25, 151.3, 151.35, 151.4, 151.45, 151.5, 151.55, 151.6, 151.65, 
151.7, 151.75, 151.8, 151.85, 151.9, 151.95, 152, 152.05, 152.1, 
152.15, 152.2, 152.25, 152.3, 152.35, 152.4, 152.45, 152.5, 152.55, 
152.6, 152.65, 152.7, 152.75, 152.8, 152.85, 152.9, 152.95, 153, 
153.05, 153.1, 153.15, 153.2, 153.25, 153.3, 153.35, 153.4, 153.45, 
153.5, 153.55, 153.6, 153.65, 153.7, 153.75, 153.8, 153.85, 153.9, 
153.95, 154, 154.05, 154.1, 154.15, 154.2, 154.25, 154.3, 154.35, 
154.4, 154.45, 154.5, 154.55, 154.6, 154.65, 154.7, 154.75, 154.8, 
154.85, 154.9, 154.95, 155, 155.05, 155.1, 155.15, 155.2, 155.25, 
155.3, 155.35, 155.4, 155.45, 155.5, 155.55, 155.6, 155.65, 155.7, 
155.75, 155.8, 155.85, 155.9, 155.95, 156, 156.05, 156.1, 156.15, 
156.2, 156.25, 156.3, 156.35, 156.4, 156.45, 156.5, 156.55, 156.6, 
156.65, 156.7, 156.75, 156.8, 156.85, 156.9, 156.95, 157, 157.05, 
157.1, 157.15, 157.2, 157.25, 157.3, 157.35, 157.4, 157.45, 157.5, 
157.55, 157.6, 157.65, 157.7, 157.75, 157.8, 157.85, 157.9, 157.95, 
158, 158.05, 158.1, 158.15, 158.2, 158.3, 158.4, 158.6, 158.65, 
158.7, 158.85, 158.9, 159, 159.15, 159.25, 159.3, 159.35, 159.45, 
159.6, 159.7, 159.75, 159.8, 159.85, 159.95, 160, 160.1, 160.15, 
160.2, 160.35, 160.4, 160.45, 160.5, 160.55, 160.6, 160.7, 160.75, 
160.85, 160.95, 161.05, 161.1, 161.2, 161.25, 161.35, 161.45, 
161.55, 161.6, 161.65, 161.7, 161.8, 161.9, 161.95, 162, 162.2, 
162.3, 162.45, 162.7, 162.75, 162.85, 162.95, 163.6, 163.65, 
163.85, 165.05, 165.1, 165.25, 165.75, 166.7, 167.75, 168.4, 
169.15, 169.9, 170.35, 171.75, 172.05, 172.85, 175.9, 176.05, 
177.25, 178.1, 179.5, 179.7, 179.8, 182.6, 182.75, 182.8, 182.85, 
182.95, 183, 183.35, 183.55, 184.25, 184.3, 185.15, 185.3, 186.65, 
186.7, 186.75, 186.8, 187.7, 187.85), long = c(0.014, 0, 0.007, 
0.007, 0, 0.007, 0, 0, 0, 0.007, 0.007, 0.007, 0.007, 0.007, 
0.014, 0.007, 0.007, 0, 0.014, 0.014, 0.007, 0.007, 0.007, 0.014, 
0.0281, 0.0211, 0.014, 0.014, 0.0281, 0.0211, 0.007, 0.014, 0.0211, 
0.014, 0.007, 0.007, 0.007, 0.0351, 0.014, 0.0351, 0.007, 0.007, 
0.0211, 0.014, 0.014, 0.0211, 0.0351, 0.0211, 0.0211, 0.007, 
0.0561, 0.0281, 0.0211, 0.0281, 0.0491, 0.014, 0.014, 0.0281, 
0.007, 0.007, 0.0281, 0.014, 0.0211, 0.007, 0.0351, 0.0281, 0.0281, 
0.0211, 0.014, 0.0351, 0.0211, 0.0561, 0.0421, 0.0351, 0.0211, 
0.0281, 0.0351, 0.0281, 0.0211, 0.014, 0.0351, 0.0281, 0.0561, 
0, 0.0211, 0.014, 0.0211, 0.0211, 0.0211, 0.0211, 0.0281, 0.0211, 
0.0491, 0.0632, 0.007, 0.0281, 0.0491, 0.0281, 0.0702, 0.0281, 
0.0211, 0.0632, 0.0632, 0.0561, 0.0561, 0.0632, 0.0772, 0.0772, 
0.0351, 0.0421, 0.0491, 0.0281, 0.0421, 0.0632, 0.0421, 0.0561, 
0.0421, 0.0351, 0.0561, 0.0421, 0.0421, 0.0912, 0.0491, 0.0702, 
0.0632, 0.0561, 0.0421, 0.0632, 0.0842, 0.1333, 0.0632, 0.0561, 
0.1123, 0.0912, 0.0702, 0.0702, 0.0842, 0.0912, 0.0632, 0.0702, 
0.0912, 0.2175, 0.0982, 0.1614, 0.2386, 0.0491, 0.0772, 0.0632, 
0.0982, 0.1263, 0.0632, 0.0912, 0.0982, 0.0772, 0.0351, 0.0211, 
0.0702, 0.0632, 0.0281, 0.0772, 0.0421, 0.0702, 0.0561, 0.0491, 
0.0702, 0.0912, 0.1123, 0.1263, 0.1333, 0.1123, 0.1404, 0.1053, 
0.1263, 0.1474, 0.0912, 0.1263, 0.1474, 0.1614, 0.1404, 0.1193, 
0.1263, 0.1193, 0.0842, 0.1333, 0.1684, 0.0982, 0.1123, 0.1825, 
0.1404, 0.1404, 0.1825, 0.0912, 0.0982, 0.0561, 0.1474, 0.1123, 
0.1123, 0.1614, 0.0912, 0.1895, 0.1614, 0.1474, 0.1263, 0.1684, 
0.1263, 0.1474, 0.1544, 0.1193, 0.1123, 0.1333, 0.1053, 0.1474, 
0.0912, 0.1263, 0.0632, 0.1333, 0.1263, 0.1263, 0.0982, 0.0632, 
0.0772, 0.1404, 0.1193, 0.1474, 0.1614, 0.0842, 0.0982, 0.0912, 
0.1053, 0.0912, 0.1193, 0.0632, 0.0842, 0.0912, 0.0772, 0.1474, 
0.1123, 0.0982, 0.1123, 0.0842, 0.1404, 0.0702, 0.0982, 0.1544, 
0.0561, 0.1193, 0.1123, 0.1053, 0.1333, 0.0772, 0.0912, 0.0842, 
0.1123, 0.0842, 0.0912, 0.1544, 0.0982, 0.1404, 0.0772, 0.0772, 
0.0982, 0.1263, 0.1123, 0.0772, 0.1053, 0.1614, 0.1193, 0.1053, 
0.1895, 0.1474, 0.1263, 0.1333, 0.1263, 0.1895, 0.1825, 0.1614, 
0.1754, 0.1123, 0.1404, 0.1263, 0.2035, 0.2526, 0.1544, 0.2105, 
0.2035, 0.1123, 0.2667, 0.1263, 0.2035, 0.1684, 0.1544, 0.1965, 
0.1544, 0.1684, 0.1263, 0.1193, 0.0842, 0.0842, 0.1193, 0.1263, 
0.1193, 0.1333, 0.1474, 0.1754, 0.1263, 0.1474, 0.1053, 0.1193, 
0.1053, 0.1123, 0.0702, 0.1333, 0.0982, 0.0772, 0.1333, 0.1263, 
0.1123, 0.1614, 0.0842, 0.1333, 0.1193, 0.1404, 0.1193, 0.1053, 
0.1123, 0.1684, 0.1333, 0.1123, 0.0982, 0.1544, 0.1123, 0.1333, 
0.0982, 0.1474, 0.1474, 0.1544, 0.1193, 0.1544, 0.1123, 0.1404, 
0.1123, 0.1684, 0.1404, 0.1263, 0.1544, 0.0632, 0.1263, 0.1263, 
0.1123, 0.1825, 0.1825, 0.1263, 0.1053, 0.1404, 0.1123, 0.1404, 
0.1193, 0.0632, 0.0772, 0.0702, 0.0421, 0.0912, 0.1614, 0.0632, 
0.0912, 0.1263, 0.0912, 0.1333, 0.0772, 0.0561, 0.0982, 0.1263, 
0.0632, 0.0702, 0.1123, 0.1263, 0.1333, 0.0982, 0.0982, 0.2316, 
0.0982, 0.1193, 0.1263, 0.0842, 0.1053, 0.1193, 0.0772, 0.0632, 
0.1474, 0.0632, 0.1053, 0.0421, 0.1123, 0.1263, 0.1544, 0.1193, 
0.1123, 0.0912, 0.0632, 0.0982, 0.1053, 0.1053, 0.0842, 0.0702, 
0.1263, 0.0842, 0.0912, 0.0702, 0.1123, 0.1333, 0.0982, 0.0702, 
0.0842, 0.0982, 0.0912, 0.0702, 0.0421, 0.0912, 0.1193, 0.1123, 
0.0912, 0.0491, 0.0842, 0.0421, 0.0702, 0.0491, 0.0281, 0.1053, 
0.0702, 0.1053, 0.0561, 0.1474, 0.0421, 0.1474, 0.1053, 0.0772, 
0.0702, 0.0702, 0.0842, 0.0912, 0.1053, 0.0702, 0.1544, 0.0842, 
0.1193, 0.0842, 0.0842, 0.0561, 0.1333, 0.1263, 0.1404, 0.1193, 
0.0702, 0.0632, 0.0632, 0.1123, 0.0912, 0.0632, 0.0702, 0.0982, 
0.0772, 0.1123, 0.1404, 0.1193, 0.0772, 0.1404, 0.0491, 0.0772, 
0.0842, 0.0982, 0.0772, 0.1053, 0.1263, 0.1474, 0.1684, 0.0561, 
0.0561, 0.1053, 0.1333, 0.1404, 0.1544, 0.1404, 0.1333, 0.1825, 
0.1123, 0.0982, 0.1614, 0.1614, 0.1544, 0.1404, 0.1193, 0.2456, 
0.2035, 0.2246, 0.2246, 0.2667, 0.1825, 0.1333, 0.2246, 0.2105, 
0.1614, 0.1333, 0.0912, 0.1053, 0.1825, 0.1474, 0.1895, 0.2105, 
0.2035, 0.2035, 0.1895, 0.1754, 0.2386, 0.3018, 0.1754, 0.2105, 
0.1614, 0.1825, 0.2456, 0.1895, 0.1965, 0.2667, 0.1614, 0.1895, 
0.1474, 0.2667, 0.1895, 0.1053, 0.1263, 0.0982, 0.0421, 0.1053, 
0.1754, 0.1053, 0.1263, 0.1754, 0.1333, 0.2105, 0.1263, 0.0702, 
0.0912, 0.1404, 0.1193, 0.1754, 0.1333, 0.1123, 0.0702, 0.1123, 
0.1053, 0.0912, 0.0982, 0.0842, 0.0842, 0.1123, 0.0772, 0.0842, 
0.1825, 0.2246, 0.1053, 0.1333, 0.1123, 0.0982, 0.1053, 0.1544, 
0.1193, 0.1333, 0.1754, 0.1333, 0.1965, 0.1544, 0.0842, 0.0842, 
0.0772, 0.0772, 0.0421, 0.0912, 0.0632, 0.0421, 0.0421, 0.0421, 
0.0421, 0.0491, 0.1123, 0.1333, 0.1404, 0.0912, 0.0561, 0.0632, 
0.0772, 0.0632, 0.0421, 0.0702, 0.0421, 0.0632, 0.0421, 0.0211, 
0.0491, 0.0351, 0.0351, 0.0421, 0.0421, 0.0351, 0.0702, 0.0772, 
0.0842, 0.0702, 0.0281, 0.0702, 0.0351, 0.0281, 0.014, 0.0351, 
0.0421, 0.0211, 0.0281, 0.0421, 0.014, 0.0211, 0.014, 0.014, 
0.0421, 0.0281, 0.0421, 0.0351, 0.0772, 0.014, 0.0281, 0.0211, 
0.0421, 0.0421, 0.0351, 0.0421, 0.007, 0.007, 0.0281, 0.0351, 
0.014, 0.0281, 0.007, 0.0211, 0.007, 0.014, 0.014, 0.007, 0.0211, 
0.0211, 0.0351, 0.014, 0.007, 0, 0, 0.007, 0.007, 0, 0.007, 0.007, 
0.007, 0, 0, 0.007, 0.007, 0.007, 0, 0.014, 0.007, 0, 0, 0.007, 
0.007, 0, 0.007, 0, 0.014, 0, 0.007, 0, 0, 0.014, 0.007, 0.007, 
0, 0, 0, 0.007, 0.007, 0, 0.007, 0.007, 0, 0.007, 0, 0, 0.007, 
0.007, 0.014, 0.014, 0.014, 0.007, 0, 0, 0.007, 0, 0, 0, 0.007, 
0.007, 0, 0.007, 0, 0.007, 0.007, 0.007, 0, 0, 0, 0, 0.007, 0, 
0.007, 0.007, 0.007, 0.007, 0, 0.007, 0.007, 0.007, 0, 0.007, 
0.014, 0.007, 0.007, 0, 0, 0.007, 0.007, 0.007, 0, 0.007, 0.007, 
0.014, 0.0211, 0, 0.007, 0.007), short = c(0, 0.007, 0, 0.007, 
0.007, 0, 0.014, 0.007, 0.007, 0, 0.007, 0, 0, 0, 0.007, 0, 0, 
0.007, 0.007, 0, 0.014, 0.007, 0.007, 0.007, 0.014, 0.007, 0, 
0.007, 0.0211, 0.007, 0.007, 0.007, 0.007, 0, 0, 0.007, 0.007, 
0.014, 0.014, 0.014, 0, 0.007, 0.0211, 0.007, 0.014, 0.014, 0.007, 
0.0281, 0.0211, 0.0421, 0.0281, 0.014, 0.0211, 0.0491, 0.007, 
0, 0.007, 0.014, 0.014, 0.0211, 0, 0.014, 0.0211, 0.014, 0.014, 
0.0281, 0, 0.0281, 0.0281, 0.0351, 0.0211, 0.014, 0.0351, 0, 
0.0491, 0.014, 0.0211, 0.0281, 0, 0.0211, 0.014, 0.007, 0.0211, 
0.014, 0.0351, 0.014, 0.0211, 0.014, 0, 0.0211, 0.0211, 0.0281, 
0.014, 0.0211, 0.014, 0.007, 0.0421, 0.0281, 0.0351, 0.014, 0.0211, 
0.0211, 0.0491, 0.0351, 0.0281, 0.0421, 0.0351, 0.0421, 0.0491, 
0.0351, 0.0561, 0.007, 0.0211, 0.0281, 0.0561, 0.0351, 0.0491, 
0.0351, 0.0491, 0.0421, 0.0281, 0.0702, 0.0772, 0.0421, 0.0491, 
0.0421, 0.0421, 0.0912, 0.0211, 0.0421, 0.0561, 0.0421, 0.0702, 
0.0561, 0.0702, 0.0772, 0.0561, 0.0842, 0.0702, 0.0772, 0.0772, 
0.0702, 0.0772, 0.1053, 0.0351, 0.0842, 0.0421, 0.0351, 0.0421, 
0.0421, 0.0281, 0.0351, 0.0561, 0.007, 0.0632, 0.0772, 0.0281, 
0.0281, 0.0491, 0.0491, 0.0421, 0.0491, 0.0632, 0.0351, 0.0772, 
0.0772, 0.0772, 0.0491, 0.0351, 0.0491, 0.0702, 0.0491, 0.0842, 
0.0491, 0.1053, 0.1474, 0.0842, 0.0491, 0.0561, 0.0772, 0.0772, 
0.0561, 0.0632, 0.0561, 0.1053, 0.0632, 0.1123, 0.0491, 0.0982, 
0.0702, 0.0842, 0.2035, 0.0842, 0.0702, 0.0772, 0.0632, 0.0351, 
0.0632, 0.0632, 0.0702, 0.0842, 0.1123, 0.0632, 0.0421, 0.0772, 
0.0772, 0.0772, 0.0772, 0.0421, 0.0561, 0.0211, 0.0351, 0.0912, 
0.0281, 0.0561, 0.0561, 0.0351, 0.0702, 0.0632, 0.0772, 0.0912, 
0.0632, 0.0772, 0.0421, 0.0632, 0.0561, 0.0702, 0.0281, 0.0281, 
0.0421, 0.0632, 0.0421, 0.0561, 0.0842, 0.0561, 0.0632, 0.0772, 
0.0632, 0.0842, 0.0561, 0.0982, 0.0632, 0.0982, 0.0702, 0.0561, 
0.0491, 0.0982, 0.0702, 0.0702, 0.0211, 0.0421, 0.0351, 0.0561, 
0.0982, 0.1193, 0.0912, 0.0912, 0.0912, 0.0772, 0.0632, 0.0982, 
0.0632, 0.0772, 0.0982, 0.0632, 0.0632, 0.0772, 0.0421, 0.0772, 
0.0421, 0.1404, 0.1474, 0.1053, 0.0912, 0.1544, 0.1263, 0.1053, 
0.1193, 0.1614, 0.0632, 0.1123, 0.0982, 0.1263, 0.1825, 0.1474, 
0.1193, 0.0702, 0.0912, 0.0491, 0.1263, 0.0912, 0.1123, 0.1193, 
0.0772, 0.0702, 0.0702, 0.0772, 0.0281, 0.0912, 0.0421, 0.1123, 
0.1193, 0.0632, 0.0281, 0.0561, 0.0772, 0.0772, 0.0842, 0.0491, 
0.0772, 0.0491, 0.0702, 0.0912, 0.0702, 0.0982, 0.0842, 0.0912, 
0.0982, 0.0982, 0.0772, 0.0772, 0.0491, 0.0842, 0.0702, 0.1123, 
0.0772, 0.1263, 0.1404, 0.1474, 0.0632, 0.1333, 0.1193, 0.0842, 
0.0632, 0.0281, 0.0702, 0.0772, 0.0982, 0.0982, 0.0842, 0.1193, 
0.1123, 0.1053, 0.0912, 0.0772, 0.0982, 0.1053, 0.1263, 0.0842, 
0.1053, 0.1193, 0.0702, 0.1053, 0.0702, 0.0702, 0.0772, 0.0842, 
0.0632, 0.0702, 0.0561, 0.0632, 0.0912, 0.0772, 0.0491, 0.0351, 
0.0632, 0.0632, 0.0842, 0.0702, 0.0842, 0.0351, 0.0982, 0.0561, 
0.0632, 0.0842, 0.0561, 0.1333, 0.1193, 0.0842, 0.0702, 0.0632, 
0.0491, 0.0702, 0.0491, 0.0211, 0.0632, 0.0561, 0.0211, 0.1053, 
0.1053, 0.0702, 0.0912, 0.1053, 0.0842, 0.1123, 0.0211, 0.0211, 
0.0491, 0.0561, 0.0702, 0.0702, 0.0842, 0.0491, 0.0772, 0.0702, 
0.0982, 0.0702, 0.0561, 0.0561, 0.0772, 0.0702, 0.0491, 0.0421, 
0.0351, 0.0632, 0.0351, 0.0421, 0.0982, 0.0421, 0.0561, 0.1193, 
0.0772, 0.0351, 0.0351, 0.0211, 0.0281, 0.0561, 0.0632, 0.0561, 
0.0421, 0.0912, 0.0912, 0.0772, 0.0281, 0.0421, 0.0491, 0.0772, 
0.014, 0.0772, 0.0491, 0.0772, 0.0632, 0.0772, 0.0632, 0.0702, 
0.0281, 0.0351, 0.0702, 0.0702, 0.0351, 0.0211, 0.0421, 0.0491, 
0.0772, 0.0632, 0.0421, 0.0772, 0.0912, 0.0281, 0.0772, 0.0912, 
0.0561, 0.1053, 0.0702, 0.0982, 0.0912, 0.0211, 0.0632, 0.1123, 
0.1333, 0.0912, 0.0632, 0.0702, 0.0842, 0.0842, 0.0561, 0.0491, 
0.0632, 0.0912, 0.0632, 0.0842, 0.1404, 0.2035, 0.0912, 0.1123, 
0.0982, 0.0561, 0.0842, 0.1123, 0.1123, 0.1123, 0.1474, 0.1754, 
0.1404, 0.1544, 0.1825, 0.1825, 0.1684, 0.0982, 0.1614, 0.1333, 
0.0842, 0.1404, 0.1263, 0.1404, 0.1754, 0.1684, 0.1895, 0.2035, 
0.1053, 0.0982, 0.1263, 0.1614, 0.1263, 0.1825, 0.1263, 0.1754, 
0.1754, 0.0702, 0.1123, 0.1053, 0.0982, 0.0632, 0.1474, 0.1193, 
0.1193, 0.0772, 0.0281, 0.0561, 0.0351, 0.0982, 0.0561, 0.0632, 
0.0772, 0.1123, 0.1053, 0.0561, 0.0702, 0.0912, 0.0912, 0.1123, 
0.0912, 0.1193, 0.0982, 0.1193, 0.0702, 0.1053, 0.0561, 0.0912, 
0.0561, 0.0842, 0.0351, 0.0632, 0.0702, 0.0632, 0.0491, 0.0842, 
0.0982, 0.0632, 0.0702, 0.0491, 0.0912, 0.0351, 0.0912, 0.0842, 
0.1123, 0.0561, 0.0632, 0.0491, 0.0491, 0.014, 0.0351, 0.0351, 
0.0211, 0.0211, 0.0351, 0.0281, 0.0561, 0.0491, 0.0491, 0.0351, 
0.0421, 0.0561, 0.014, 0.0491, 0.0561, 0.0561, 0.0281, 0.0421, 
0.0281, 0.007, 0.0421, 0.0421, 0.007, 0.0281, 0.007, 0.0281, 
0.0351, 0.0561, 0.007, 0.0491, 0.0281, 0.0351, 0.0491, 0.007, 
0.0421, 0.007, 0.007, 0.0211, 0.014, 0.014, 0.0211, 0.014, 0, 
0.0421, 0.014, 0.014, 0.0211, 0.0211, 0.0211, 0.0281, 0.0421, 
0.0281, 0.014, 0.0211, 0, 0.0351, 0.0211, 0, 0.014, 0.014, 0, 
0, 0, 0.007, 0.0211, 0, 0, 0.014, 0, 0.014, 0.007, 0.014, 0.007, 
0, 0, 0.014, 0.014, 0, 0.007, 0.007, 0, 0, 0.007, 0, 0.007, 0, 
0.007, 0.014, 0, 0, 0.007, 0.007, 0, 0.007, 0.007, 0.007, 0, 
0, 0.007, 0, 0.007, 0, 0.007, 0, 0.014, 0.007, 0, 0.007, 0.007, 
0.007, 0.007, 0.007, 0, 0.007, 0.007, 0, 0, 0.007, 0, 0.007, 
0.007, 0, 0, 0, 0.007, 0, 0.007, 0.007, 0.007, 0, 0.007, 0.007, 
0.007, 0, 0, 0.007, 0, 0.007, 0, 0, 0, 0.007, 0.007, 0.007, 0.007, 
0.007, 0.007, 0, 0, 0, 0, 0.007, 0, 0, 0, 0.007, 0.007, 0.014, 
0, 0.007, 0.007, 0.007, 0, 0, 0, 0.007, 0, 0.007, 0, 0, 0.014, 
0, 0)), class = "data.frame", row.names = c(NA, -744L))

instrument <- "GBP_JPY"
timestamp <- .POSIXct(1638316800)
currentprice <- 150.64

layers <- list(
  ggplot2::layer(geom = ggplot2::GeomCol, mapping = ggplot2::aes(x = .data$price, y = .data$long),
          stat = ggplot2::StatIdentity, position = ggplot2::PositionIdentity,
          params = list(na.rm = FALSE, colour = "#1aa1a6", fill = "#1aa1a6"),
          inherit.aes = TRUE, check.aes = FALSE, check.param = FALSE),
  ggplot2::layer(geom = ggplot2::GeomCol, mapping = ggplot2::aes(x = .data$price, y = -.data$short),
          stat = ggplot2::StatIdentity, position = ggplot2::PositionIdentity,
          params = list(na.rm = FALSE, colour = "#586e75", fill = "#586e75"),
          inherit.aes = TRUE, check.aes = FALSE, check.param = FALSE),
  ggplot2::layer(geom = ggplot2::GeomVline, data = NULL, mapping = ggplot2::aes(xintercept = currentprice),
          stat = ggplot2::StatIdentity, position = ggplot2::PositionIdentity,
          params = list(na.rm = FALSE, colour = "#db4525", alpha = 0.5),
          inherit.aes = FALSE, check.aes = FALSE, check.param = FALSE),
  ggplot2::scale_x_continuous(breaks = function(x) pretty.default(x, n = 40L)),
  ggplot2::scale_y_continuous(),
  ggplot2::labs(x = "Price", y = "% short / % long",
                title = paste0("OANDA Position Book: ", instrument, " at ",
                        format.POSIXct(timestamp), " / Current Price: ", currentprice)),
  ggplot2::coord_flip(),
  ichimoku:::theme_ichimoku_light()
)
print(ggplot2::ggplot(data = df) + layers)


## ----oandai, eval=FALSE-------------------------------------------------------
#  oanda_instruments()

## ----ins, echo=FALSE----------------------------------------------------------
print(ichimoku:::.oanda_instruments)

