% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5WriteScalar}
\alias{h5WriteScalar}
\alias{h5WriteScalar.H5Group}
\alias{h5WriteScalar.H5File}
\alias{h5WriteScalar.character}
\title{Write a scalar into HDF5 file}
\usage{
h5WriteScalar(x, name, robj, ...)

\method{h5WriteScalar}{H5Group}(x, name, robj, stype = c("utf8", "ascii7"), ...)

\method{h5WriteScalar}{H5File}(x, name, robj, ...)

\method{h5WriteScalar}{character}(x, name, robj, overwrite = FALSE, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{name}{Name of an HDF5 link.}

\item{robj}{A scalar object.}

\item{...}{Arguments passed to \code{H5File$create_dataset()}. See 
\code{link[hdf5r:H5File-class]{H5File}}.}

\item{stype}{'utf8' or 'ascii7'. Passed to \code{\link{h5GuessDtype}}.}

\item{overwrite}{Whether or not to overwrite the existing \code{name}.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Low-level helper function to write scalar R data into HDF5 dataset. Data will 
be written into scalar space instead of array space.
}
\note{
If you want to write \code{robj} into array space, you should use 
\code{\link{h5WriteDataset}}.
}
\examples{
tmp.file <- tempfile(fileext = ".h5")
h5CreateFile(tmp.file)

h5WriteScalar(tmp.file,  name = "test/scalar", TRUE)
x <- h5ReadDataset(tmp.file, name = "test/scalar")
x

h5WriteScalar(tmp.file,  name = "test/scalar", 100.0, overwrite = TRUE)
x <- h5ReadDataset(tmp.file, name = "test/scalar")
x

h5WriteScalar(tmp.file,  name = "test/scalar", "ABC", overwrite = TRUE)
x <- h5Read(tmp.file, name = "test/scalar")
x

h5WriteScalar(tmp.file,  name = "test/factor", factor("ABC"))
x <- h5ReadDataset(tmp.file, name = "test/factor")
x

}
