% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5CreateDataset}
\alias{h5CreateDataset}
\alias{h5CreateDataset.H5Group}
\alias{h5CreateDataset.H5File}
\alias{h5CreateDataset.character}
\title{Create a new empty HDF5 dataset}
\usage{
h5CreateDataset(x, name, ...)

\method{h5CreateDataset}{H5Group}(
  x,
  name,
  dims,
  dtype = NULL,
  storage.mode = numeric(),
  stype = c("utf8", "ascii7"),
  maxdims = NULL,
  chunk_size = "auto",
  gzip_level = 6,
  ...
)

\method{h5CreateDataset}{H5File}(
  x,
  name,
  dims,
  dtype = NULL,
  storage.mode = numeric(),
  stype = c("utf8", "ascii7"),
  maxdims = NULL,
  chunk_size = "auto",
  gzip_level = 6,
  ...
)

\method{h5CreateDataset}{character}(
  x,
  name,
  dims,
  dtype = NULL,
  storage.mode = numeric(),
  stype = c("utf8", "ascii7"),
  maxdims = NULL,
  overwrite = FALSE,
  chunk_size = "auto",
  gzip_level = 6,
  ...
)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{name}{Name of the new HDF5 dataset.}

\item{...}{Arguments passed to \code{H5File$create_dataset()}. Also see 
\code{[hdf5r:H5File-class]{H5File}}.}

\item{dims}{Dimensions of the new dataset.}

\item{dtype}{The H5 datatype to use for the creation of the object. Must be 
an \code{\link[hdf5r:H5T-class]{H5T}}. If set to \code{NULL}, it will be 
guessed through \code{\link{h5GuessDtype}}, according to \code{storage.mode}.}

\item{storage.mode}{Object used to guess the HDF5 datatype. Default is 
\code{\link{numeric}()}.}

\item{stype}{'utf8' or 'ascii7'. Passed to \code{\link{h5GuessDtype}}.}

\item{maxdims}{The maximal dimensions of the space. Default is \code{dims}.}

\item{chunk_size}{Size of the chunk. Must have the same length as the dataset 
dimension. If \code{NULL}, no chunking is used. If set to \code{"auto"}, the 
size of each chunk will be estimated according to \code{maxdims} and the byte 
size of \code{dtype}, using \code{\link[hdf5r]{guess_chunks}}.}

\item{gzip_level}{Enable zipping at the level given here. Only if chunk_dims 
is not \code{NULL}.}

\item{overwrite}{Whether or not to overwrite the existing HDF5 dataset.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Create a new empty HDF5 dataset
}
\examples{
tmp.file <- tempfile(fileext = ".h5")
h5CreateFile(tmp.file)

m <- matrix(0, 10, 5)
h5CreateDataset(tmp.file, "g1/m", dim(m))

m2 <- c("a", "b", "c")
h5CreateDataset(tmp.file, "g2/m2", length(m2), storage.mode = m2)

}
\seealso{
\code{\link[hdf5r]{H5File}} and \code{\link[hdf5r]{H5Group}} for the 
\code{$create_dataset()} methods.
}
