// Generated by rstantools.  Do not edit by hand.

/*
    hbamr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hbamr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hbamr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_HBAM_MULTI_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 106> locations_array__ =
  {" (found before start of program)",
  " (in 'HBAM_MULTI', line 27, column 2 to column 25)",
  " (in 'HBAM_MULTI', line 28, column 2 to column 24)",
  " (in 'HBAM_MULTI', line 29, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 30, column 2 to column 26)",
  " (in 'HBAM_MULTI', line 31, column 2 to column 26)",
  " (in 'HBAM_MULTI', line 32, column 2 to column 25)",
  " (in 'HBAM_MULTI', line 33, column 2 to column 30)",
  " (in 'HBAM_MULTI', line 34, column 2 to column 40)",
  " (in 'HBAM_MULTI', line 35, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 36, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 37, column 2 to column 27)",
  " (in 'HBAM_MULTI', line 38, column 2 to column 17)",
  " (in 'HBAM_MULTI', line 39, column 2 to column 23)",
  " (in 'HBAM_MULTI', line 40, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 43, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 44, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 45, column 2 to column 21)",
  " (in 'HBAM_MULTI', line 46, column 2 to column 24)",
  " (in 'HBAM_MULTI', line 47, column 2 to column 75)",
  " (in 'HBAM_MULTI', line 48, column 2 to column 95)",
  " (in 'HBAM_MULTI', line 49, column 2 to column 92)",
  " (in 'HBAM_MULTI', line 50, column 2 to column 38)",
  " (in 'HBAM_MULTI', line 91, column 2 to column 37)",
  " (in 'HBAM_MULTI', line 92, column 2 to column 53)",
  " (in 'HBAM_MULTI', line 93, column 2 to column 74)",
  " (in 'HBAM_MULTI', line 94, column 2 to column 71)",
  " (in 'HBAM_MULTI', line 95, column 2 to column 86)",
  " (in 'HBAM_MULTI', line 51, column 2 to column 20)",
  " (in 'HBAM_MULTI', line 52, column 2 to column 25)",
  " (in 'HBAM_MULTI', line 53, column 2 to column 25)",
  " (in 'HBAM_MULTI', line 55, column 4 to column 67)",
  " (in 'HBAM_MULTI', line 56, column 4 to column 67)",
  " (in 'HBAM_MULTI', line 57, column 4 to column 68)",
  " (in 'HBAM_MULTI', line 58, column 4 to column 52)",
  " (in 'HBAM_MULTI', line 54, column 17 to line 59, column 3)",
  " (in 'HBAM_MULTI', line 54, column 2 to line 59, column 3)",
  " (in 'HBAM_MULTI', line 61, column 4 to line 65, column 41)",
  " (in 'HBAM_MULTI', line 60, column 21 to line 66, column 3)",
  " (in 'HBAM_MULTI', line 60, column 2 to line 66, column 3)",
  " (in 'HBAM_MULTI', line 69, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 70, column 2 to column 32)",
  " (in 'HBAM_MULTI', line 71, column 2 to column 32)",
  " (in 'HBAM_MULTI', line 72, column 2 to column 32)",
  " (in 'HBAM_MULTI', line 73, column 2 to column 49)",
  " (in 'HBAM_MULTI', line 74, column 2 to column 31)",
  " (in 'HBAM_MULTI', line 75, column 2 to column 31)",
  " (in 'HBAM_MULTI', line 76, column 2 to column 28)",
  " (in 'HBAM_MULTI', line 77, column 2 to column 46)",
  " (in 'HBAM_MULTI', line 78, column 2 to column 45)",
  " (in 'HBAM_MULTI', line 79, column 2 to column 45)",
  " (in 'HBAM_MULTI', line 80, column 2 to column 22)",
  " (in 'HBAM_MULTI', line 81, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 82, column 2 to column 37)",
  " (in 'HBAM_MULTI', line 83, column 2 to column 28)",
  " (in 'HBAM_MULTI', line 84, column 2 to column 27)",
  " (in 'HBAM_MULTI', line 88, column 4 to column 42)",
  " (in 'HBAM_MULTI', line 86, column 4 to column 27)",
  " (in 'HBAM_MULTI', line 85, column 2 to line 88, column 42)",
  " (in 'HBAM_MULTI', line 2, column 2 to column 19)",
  " (in 'HBAM_MULTI', line 3, column 2 to column 19)",
  " (in 'HBAM_MULTI', line 4, column 2 to column 19)",
  " (in 'HBAM_MULTI', line 5, column 2 to column 23)",
  " (in 'HBAM_MULTI', line 6, column 8 to column 13)",
  " (in 'HBAM_MULTI', line 6, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 7, column 8 to column 13)",
  " (in 'HBAM_MULTI', line 7, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 8, column 8 to column 9)",
  " (in 'HBAM_MULTI', line 8, column 2 to column 29)",
  " (in 'HBAM_MULTI', line 9, column 2 to column 19)",
  " (in 'HBAM_MULTI', line 10, column 2 to column 30)",
  " (in 'HBAM_MULTI', line 11, column 2 to column 30)",
  " (in 'HBAM_MULTI', line 12, column 32 to column 37)",
  " (in 'HBAM_MULTI', line 12, column 2 to column 41)",
  " (in 'HBAM_MULTI', line 13, column 32 to column 33)",
  " (in 'HBAM_MULTI', line 13, column 2 to column 37)",
  " (in 'HBAM_MULTI', line 14, column 2 to column 31)",
  " (in 'HBAM_MULTI', line 15, column 31 to column 36)",
  " (in 'HBAM_MULTI', line 15, column 2 to column 46)",
  " (in 'HBAM_MULTI', line 16, column 2 to column 33)",
  " (in 'HBAM_MULTI', line 17, column 2 to column 32)",
  " (in 'HBAM_MULTI', line 20, column 2 to column 63)",
  " (in 'HBAM_MULTI', line 21, column 2 to column 55)",
  " (in 'HBAM_MULTI', line 22, column 31 to column 36)",
  " (in 'HBAM_MULTI', line 22, column 2 to column 64)",
  " (in 'HBAM_MULTI', line 23, column 2 to column 35)",
  " (in 'HBAM_MULTI', line 24, column 2 to column 90)",
  " (in 'HBAM_MULTI', line 27, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 28, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 30, column 8 to column 9)",
  " (in 'HBAM_MULTI', line 31, column 10 to column 11)",
  " (in 'HBAM_MULTI', line 32, column 10 to column 11)",
  " (in 'HBAM_MULTI', line 37, column 20 to column 21)",
  " (in 'HBAM_MULTI', line 38, column 10 to column 11)",
  " (in 'HBAM_MULTI', line 39, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 43, column 8 to column 9)",
  " (in 'HBAM_MULTI', line 44, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 45, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 46, column 9 to column 14)",
  " (in 'HBAM_MULTI', line 47, column 31 to column 32)",
  " (in 'HBAM_MULTI', line 48, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 49, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 92, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 93, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 94, column 9 to column 10)",
  " (in 'HBAM_MULTI', line 95, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_HBAM_MULTI final : public model_base_crtp<model_HBAM_MULTI> {
private:
  int N;
  int J;
  int G;
  int N_obs;
  std::vector<int> ii;
  std::vector<int> jj;
  std::vector<int> gg;
  int B;
  int L;
  int R;
  Eigen::Matrix<double,-1,1> Y_data__;
  Eigen::Matrix<double,-1,1> V_data__;
  int CV;
  Eigen::Matrix<double,-1,1> holdout_data__;
  double sigma_mu_alpha;
  double sigma_mu_beta;
  double sigma_alpha_prior_rate;
  double tau_prior_rate;
  Eigen::Matrix<double,-1,1> not_holdout_data__;
  double mean_mu_simplexes;
  double sd_mu_simplexes;
  Eigen::Map<Eigen::Matrix<double,-1,1>> Y{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> V{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> holdout{nullptr, 0};
  Eigen::Map<Eigen::Matrix<double,-1,1>> not_holdout{nullptr, 0};
public:
  ~model_HBAM_MULTI() {}
  model_HBAM_MULTI(stan::io::var_context& context__, unsigned int
                   random_seed__ = 0, std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_HBAM_MULTI_namespace::model_HBAM_MULTI";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 59;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{});
      N = std::numeric_limits<int>::min();
      current_statement__ = 59;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 59;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization", "J", "int",
        std::vector<size_t>{});
      J = std::numeric_limits<int>::min();
      current_statement__ = 60;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 60;
      stan::math::check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 61;
      context__.validate_dims("data initialization", "G", "int",
        std::vector<size_t>{});
      G = std::numeric_limits<int>::min();
      current_statement__ = 61;
      G = context__.vals_i("G")[(1 - 1)];
      current_statement__ = 61;
      stan::math::check_greater_or_equal(function__, "G", G, 1);
      current_statement__ = 62;
      context__.validate_dims("data initialization", "N_obs", "int",
        std::vector<size_t>{});
      N_obs = std::numeric_limits<int>::min();
      current_statement__ = 62;
      N_obs = context__.vals_i("N_obs")[(1 - 1)];
      current_statement__ = 62;
      stan::math::check_greater_or_equal(function__, "N_obs", N_obs, 1);
      current_statement__ = 63;
      stan::math::validate_non_negative_index("ii", "N_obs", N_obs);
      current_statement__ = 64;
      context__.validate_dims("data initialization", "ii", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      ii = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 64;
      ii = context__.vals_i("ii");
      current_statement__ = 64;
      stan::math::check_greater_or_equal(function__, "ii", ii, 1);
      current_statement__ = 65;
      stan::math::validate_non_negative_index("jj", "N_obs", N_obs);
      current_statement__ = 66;
      context__.validate_dims("data initialization", "jj", "int",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      jj = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      current_statement__ = 66;
      jj = context__.vals_i("jj");
      current_statement__ = 66;
      stan::math::check_greater_or_equal(function__, "jj", jj, 1);
      current_statement__ = 67;
      stan::math::validate_non_negative_index("gg", "N", N);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "gg", "int",
        std::vector<size_t>{static_cast<size_t>(N)});
      gg = std::vector<int>(N, std::numeric_limits<int>::min());
      current_statement__ = 68;
      gg = context__.vals_i("gg");
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "gg", gg, 1);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "B", "int",
        std::vector<size_t>{});
      B = std::numeric_limits<int>::min();
      current_statement__ = 69;
      B = context__.vals_i("B")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "B", B, 1);
      current_statement__ = 70;
      context__.validate_dims("data initialization", "L", "int",
        std::vector<size_t>{});
      L = std::numeric_limits<int>::min();
      current_statement__ = 70;
      L = context__.vals_i("L")[(1 - 1)];
      current_statement__ = 70;
      stan::math::check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 70;
      stan::math::check_less_or_equal(function__, "L", L, J);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "R", "int",
        std::vector<size_t>{});
      R = std::numeric_limits<int>::min();
      current_statement__ = 71;
      R = context__.vals_i("R")[(1 - 1)];
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 71;
      stan::math::check_less_or_equal(function__, "R", R, J);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("Y", "N_obs", N_obs);
      current_statement__ = 73;
      context__.validate_dims("data initialization", "Y", "double",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      Y_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                   std::numeric_limits<double>::quiet_NaN());
      new (&Y) Eigen::Map<Eigen::Matrix<double,-1,1>>(Y_data__.data(), N_obs);
      {
        std::vector<local_scalar_t__> Y_flat__;
        current_statement__ = 73;
        Y_flat__ = context__.vals_r("Y");
        current_statement__ = 73;
        pos__ = 1;
        current_statement__ = 73;
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          current_statement__ = 73;
          stan::model::assign(Y, Y_flat__[(pos__ - 1)],
            "assigning variable Y", stan::model::index_uni(sym1__));
          current_statement__ = 73;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 73;
      stan::math::check_greater_or_equal(function__, "Y", Y, -B);
      current_statement__ = 73;
      stan::math::check_less_or_equal(function__, "Y", Y, B);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("V", "N", N);
      current_statement__ = 75;
      context__.validate_dims("data initialization", "V", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      V_data__ = Eigen::Matrix<double,-1,1>::Constant(N,
                   std::numeric_limits<double>::quiet_NaN());
      new (&V) Eigen::Map<Eigen::Matrix<double,-1,1>>(V_data__.data(), N);
      {
        std::vector<local_scalar_t__> V_flat__;
        current_statement__ = 75;
        V_flat__ = context__.vals_r("V");
        current_statement__ = 75;
        pos__ = 1;
        current_statement__ = 75;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 75;
          stan::model::assign(V, V_flat__[(pos__ - 1)],
            "assigning variable V", stan::model::index_uni(sym1__));
          current_statement__ = 75;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 75;
      stan::math::check_greater_or_equal(function__, "V", V, -B);
      current_statement__ = 75;
      stan::math::check_less_or_equal(function__, "V", V, B);
      current_statement__ = 76;
      context__.validate_dims("data initialization", "CV", "int",
        std::vector<size_t>{});
      CV = std::numeric_limits<int>::min();
      current_statement__ = 76;
      CV = context__.vals_i("CV")[(1 - 1)];
      current_statement__ = 76;
      stan::math::check_greater_or_equal(function__, "CV", CV, 0);
      current_statement__ = 76;
      stan::math::check_less_or_equal(function__, "CV", CV, 1);
      current_statement__ = 77;
      stan::math::validate_non_negative_index("holdout", "N_obs", N_obs);
      current_statement__ = 78;
      context__.validate_dims("data initialization", "holdout", "double",
        std::vector<size_t>{static_cast<size_t>(N_obs)});
      holdout_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                         std::numeric_limits<double>::quiet_NaN());
      new (&holdout)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(holdout_data__.data(), N_obs);
      {
        std::vector<local_scalar_t__> holdout_flat__;
        current_statement__ = 78;
        holdout_flat__ = context__.vals_r("holdout");
        current_statement__ = 78;
        pos__ = 1;
        current_statement__ = 78;
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          current_statement__ = 78;
          stan::model::assign(holdout, holdout_flat__[(pos__ - 1)],
            "assigning variable holdout", stan::model::index_uni(sym1__));
          current_statement__ = 78;
          pos__ = (pos__ + 1);
        }
      }
      current_statement__ = 78;
      stan::math::check_greater_or_equal(function__, "holdout", holdout, 0);
      current_statement__ = 78;
      stan::math::check_less_or_equal(function__, "holdout", holdout, 1);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "sigma_mu_alpha",
        "double", std::vector<size_t>{});
      sigma_mu_alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 79;
      sigma_mu_alpha = context__.vals_r("sigma_mu_alpha")[(1 - 1)];
      current_statement__ = 79;
      stan::math::check_greater_or_equal(function__, "sigma_mu_alpha",
        sigma_mu_alpha, 0);
      current_statement__ = 80;
      context__.validate_dims("data initialization", "sigma_mu_beta",
        "double", std::vector<size_t>{});
      sigma_mu_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 80;
      sigma_mu_beta = context__.vals_r("sigma_mu_beta")[(1 - 1)];
      current_statement__ = 80;
      stan::math::check_greater_or_equal(function__, "sigma_mu_beta",
        sigma_mu_beta, 0);
      current_statement__ = 81;
      sigma_alpha_prior_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 81;
      sigma_alpha_prior_rate = ((5 - 1) / (B / 8.0));
      current_statement__ = 82;
      tau_prior_rate = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 82;
      tau_prior_rate = ((2 - 1) / (B / 5.0));
      current_statement__ = 83;
      stan::math::validate_non_negative_index("not_holdout", "N_obs", N_obs);
      current_statement__ = 84;
      not_holdout_data__ = Eigen::Matrix<double,-1,1>::Constant(N_obs,
                             std::numeric_limits<double>::quiet_NaN());
      new (&not_holdout)
        Eigen::Map<Eigen::Matrix<double,-1,1>>(not_holdout_data__.data(),
        N_obs);
      current_statement__ = 84;
      stan::model::assign(not_holdout, stan::math::subtract(1, holdout),
        "assigning variable not_holdout");
      current_statement__ = 85;
      mean_mu_simplexes = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 85;
      mean_mu_simplexes = (1.0 / G);
      current_statement__ = 86;
      sd_mu_simplexes = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 86;
      sd_mu_simplexes = stan::math::sqrt(((mean_mu_simplexes * (1 -
                          mean_mu_simplexes)) / ((50 * G) + 1)));
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__,
        "sigma_alpha_prior_rate", sigma_alpha_prior_rate, 0);
      current_statement__ = 82;
      stan::math::check_greater_or_equal(function__, "tau_prior_rate",
        tau_prior_rate, 0);
      current_statement__ = 84;
      stan::math::check_greater_or_equal(function__, "not_holdout",
        not_holdout, 0);
      current_statement__ = 84;
      stan::math::check_less_or_equal(function__, "not_holdout", not_holdout,
        1);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("alpha_raw", "N", N);
      current_statement__ = 88;
      stan::math::validate_non_negative_index("beta_raw", "N", N);
      current_statement__ = 89;
      stan::math::validate_non_negative_index("theta_raw", "J", J);
      current_statement__ = 90;
      stan::math::validate_positive_index("mu_alpha_raw", "G", G);
      current_statement__ = 91;
      stan::math::validate_positive_index("mu_beta_raw", "G", G);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("eta", "N", N);
      current_statement__ = 93;
      stan::math::validate_positive_index("rho", "J", J);
      current_statement__ = 94;
      stan::math::validate_non_negative_index("lambda_raw", "N", N);
      current_statement__ = 95;
      stan::math::validate_non_negative_index("theta", "J", J);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("alpha0", "N", N);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("beta0", "N", N);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("log_lik", "N_obs", N_obs);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("lambda", "N", N);
      current_statement__ = 100;
      stan::math::validate_non_negative_index("mu_alpha", "G", G);
      current_statement__ = 101;
      stan::math::validate_non_negative_index("mu_beta", "G", G);
      current_statement__ = 102;
      stan::math::validate_non_negative_index("kappa", "N", N);
      current_statement__ = 103;
      stan::math::validate_non_negative_index("alpha", "N", N);
      current_statement__ = 104;
      stan::math::validate_non_negative_index("beta", "N", N);
      current_statement__ = 105;
      stan::math::validate_non_negative_index("chi", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = (N * 2) + (N * 2) + 2 + J + (G - 1) + (G - 1) + 1 + 1 +
      1 + 1 + N + (J - 1) + N + 1;
  }
  inline std::string model_name() const final {
    return "model_HBAM_MULTI";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_HBAM_MULTI_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<local_scalar_t__,-1,-1> alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      current_statement__ = 1;
      alpha_raw = in__.template read<
                    Eigen::Matrix<local_scalar_t__,-1,-1>>(N, 2);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      current_statement__ = 2;
      beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N,
                   2);
      Eigen::Matrix<local_scalar_t__,-1,1> theta_lr =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      current_statement__ = 3;
      theta_lr = in__.template read_constrain_ordered<
                   Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, 2);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 4;
      theta_raw = in__.template read<std::vector<local_scalar_t__>>(J);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 5;
      mu_alpha_raw = in__.template read_constrain_simplex<
                       Eigen::Matrix<local_scalar_t__,-1,1>,
                       jacobian__>(lp__, G);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 6;
      mu_beta_raw = in__.template read_constrain_simplex<
                      Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__,
                      G);
      local_scalar_t__ sigma_alpha = DUMMY_VAR__;
      current_statement__ = 7;
      sigma_alpha = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 8;
      sigma_beta = in__.template read_constrain_lub<local_scalar_t__,
                     jacobian__>(0, 2, lp__);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 9;
      nu = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(3,
             30, lp__);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 10;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 11;
      eta = in__.template read_constrain_lb<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, N);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 12;
      rho = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 13;
      lambda_raw = in__.template read<
                     Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      local_scalar_t__ psi = DUMMY_VAR__;
      current_statement__ = 14;
      psi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      std::vector<local_scalar_t__> theta =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> alpha0 =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta0 =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> log_lik =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N_obs, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 19;
      stan::model::assign(lambda,
        stan::math::inv_logit(
          stan::math::add(psi, stan::math::multiply(lambda_raw, 3))),
        "assigning variable lambda");
      Eigen::Matrix<local_scalar_t__,-1,1> mu_alpha =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 20;
      stan::model::assign(mu_alpha,
        stan::math::multiply(
          stan::math::divide(
            stan::math::subtract(mu_alpha_raw, mean_mu_simplexes),
            sd_mu_simplexes), sigma_mu_alpha), "assigning variable mu_alpha");
      Eigen::Matrix<local_scalar_t__,-1,1> mu_beta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 21;
      stan::model::assign(mu_beta,
        stan::math::multiply(
          stan::math::divide(
            stan::math::subtract(mu_beta_raw, mean_mu_simplexes),
            sd_mu_simplexes), sigma_mu_beta), "assigning variable mu_beta");
      local_scalar_t__ eta_scale = DUMMY_VAR__;
      current_statement__ = 22;
      eta_scale = (tau * J);
      current_statement__ = 28;
      stan::model::assign(theta, theta_raw, "assigning variable theta");
      current_statement__ = 29;
      stan::model::assign(theta,
        stan::model::rvalue(theta_lr, "theta_lr", stan::model::index_uni(1)),
        "assigning variable theta", stan::model::index_uni(L));
      current_statement__ = 30;
      stan::model::assign(theta,
        stan::model::rvalue(theta_lr, "theta_lr", stan::model::index_uni(2)),
        "assigning variable theta", stan::model::index_uni(R));
      current_statement__ = 36;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 31;
        stan::model::assign(alpha0,
          ((stan::model::rvalue(alpha_raw, "alpha_raw",
              stan::model::index_uni(i), stan::model::index_uni(1)) *
          sigma_alpha) +
          stan::model::rvalue(mu_alpha, "mu_alpha",
            stan::model::index_uni(
              stan::model::rvalue(gg, "gg", stan::model::index_uni(i))))),
          "assigning variable alpha0", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 32;
        stan::model::assign(alpha0,
          ((stan::model::rvalue(alpha_raw, "alpha_raw",
              stan::model::index_uni(i), stan::model::index_uni(2)) *
          sigma_alpha) +
          stan::model::rvalue(mu_alpha, "mu_alpha",
            stan::model::index_uni(
              stan::model::rvalue(gg, "gg", stan::model::index_uni(i))))),
          "assigning variable alpha0", stan::model::index_uni(i),
          stan::model::index_uni(2));
        current_statement__ = 33;
        stan::model::assign(beta0,
          stan::math::exp(
            ((stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_uni(i), stan::model::index_uni(1)) *
            sigma_beta) +
            stan::model::rvalue(mu_beta, "mu_beta",
              stan::model::index_uni(
                stan::model::rvalue(gg, "gg", stan::model::index_uni(i)))))),
          "assigning variable beta0", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 34;
        stan::model::assign(beta0,
          -stan::math::exp(
             (stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_uni(i), stan::model::index_uni(2)) *
             sigma_beta)), "assigning variable beta0",
          stan::model::index_uni(i), stan::model::index_uni(2));
      }
      current_statement__ = 39;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 37;
        stan::model::assign(log_lik,
          stan::math::log_mix(
            stan::model::rvalue(lambda, "lambda",
              stan::model::index_uni(
                stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))),
            stan::math::normal_lpdf<false>(
              stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
              (stan::model::rvalue(alpha0, "alpha0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(1)) +
              (stan::model::rvalue(beta0, "beta0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(1)) *
              stan::model::rvalue(theta, "theta",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
              (stan::math::sqrt(
                 stan::model::rvalue(eta, "eta",
                   stan::model::index_uni(
                     stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
              *
              stan::model::rvalue(rho, "rho",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
            stan::math::normal_lpdf<false>(
              stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
              (stan::model::rvalue(alpha0, "alpha0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(2)) +
              (stan::model::rvalue(beta0, "beta0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(2)) *
              stan::model::rvalue(theta, "theta",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
              (stan::math::sqrt(
                 stan::model::rvalue(eta, "eta",
                   stan::model::index_uni(
                     stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
              *
              stan::model::rvalue(rho, "rho",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n))))))),
          "assigning variable log_lik", stan::model::index_uni(n));
      }
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "lambda", lambda, 0);
      current_statement__ = 19;
      stan::math::check_less_or_equal(function__, "lambda", lambda, 1);
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "eta_scale", eta_scale,
        0);
      {
        current_statement__ = 40;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_raw, 0, (B /
                         2.0)));
        current_statement__ = 41;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(theta_lr, 0, (B /
                         2.0)));
        current_statement__ = 42;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(alpha_raw, "alpha_raw",
                           stan::model::index_omni(),
                           stan::model::index_uni(1)), 0, 1));
        current_statement__ = 43;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(alpha_raw, "alpha_raw",
                           stan::model::index_omni(),
                           stan::model::index_uni(2)), 0, 1));
        current_statement__ = 44;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(sigma_alpha, 5,
                         sigma_alpha_prior_rate));
        current_statement__ = 45;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(beta_raw, "beta_raw",
                           stan::model::index_omni(),
                           stan::model::index_uni(1)), 0, 1));
        current_statement__ = 46;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(
                         stan::model::rvalue(beta_raw, "beta_raw",
                           stan::model::index_omni(),
                           stan::model::index_uni(2)), 0, 1));
        current_statement__ = 47;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(sigma_beta, 9, 40));
        current_statement__ = 48;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(mu_alpha_raw,
                         stan::math::rep_vector(50, G)));
        current_statement__ = 49;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(mu_beta_raw,
                         stan::math::rep_vector(50, G)));
        current_statement__ = 50;
        lp_accum__.add(stan::math::scaled_inv_chi_square_lpdf<propto__>(eta,
                         nu, eta_scale));
        current_statement__ = 51;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(nu, 25, 2.5));
        current_statement__ = 52;
        lp_accum__.add(stan::math::gamma_lpdf<propto__>(tau, 2,
                         tau_prior_rate));
        current_statement__ = 53;
        lp_accum__.add(stan::math::dirichlet_lpdf<propto__>(rho,
                         stan::math::rep_vector(50, J)));
        current_statement__ = 54;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(lambda_raw, 0, 1));
        current_statement__ = 55;
        lp_accum__.add(stan::math::lognormal_lpdf<propto__>(psi, 1.4, .5));
        current_statement__ = 58;
        if (stan::math::logical_eq(CV, 0)) {
          current_statement__ = 57;
          lp_accum__.add(stan::math::sum(log_lik));
        } else {
          current_statement__ = 56;
          lp_accum__.add(stan::math::sum(
                           stan::math::elt_multiply(log_lik, not_holdout)));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_HBAM_MULTI_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      Eigen::Matrix<double,-1,-1> alpha_raw =
        Eigen::Matrix<double,-1,-1>::Constant(N, 2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      alpha_raw = in__.template read<
                    Eigen::Matrix<local_scalar_t__,-1,-1>>(N, 2);
      Eigen::Matrix<double,-1,-1> beta_raw =
        Eigen::Matrix<double,-1,-1>::Constant(N, 2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 2;
      beta_raw = in__.template read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N,
                   2);
      Eigen::Matrix<double,-1,1> theta_lr =
        Eigen::Matrix<double,-1,1>::Constant(2,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 3;
      theta_lr = in__.template read_constrain_ordered<
                   Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, 2);
      std::vector<double> theta_raw =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      theta_raw = in__.template read<std::vector<local_scalar_t__>>(J);
      Eigen::Matrix<double,-1,1> mu_alpha_raw =
        Eigen::Matrix<double,-1,1>::Constant(G,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      mu_alpha_raw = in__.template read_constrain_simplex<
                       Eigen::Matrix<local_scalar_t__,-1,1>,
                       jacobian__>(lp__, G);
      Eigen::Matrix<double,-1,1> mu_beta_raw =
        Eigen::Matrix<double,-1,1>::Constant(G,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 6;
      mu_beta_raw = in__.template read_constrain_simplex<
                      Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__,
                      G);
      double sigma_alpha = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 7;
      sigma_alpha = in__.template read_constrain_lb<local_scalar_t__,
                      jacobian__>(0, lp__);
      double sigma_beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 8;
      sigma_beta = in__.template read_constrain_lub<local_scalar_t__,
                     jacobian__>(0, 2, lp__);
      double nu = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 9;
      nu = in__.template read_constrain_lub<local_scalar_t__, jacobian__>(3,
             30, lp__);
      double tau = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 10;
      tau = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      Eigen::Matrix<double,-1,1> eta =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 11;
      eta = in__.template read_constrain_lb<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(0, lp__, N);
      Eigen::Matrix<double,-1,1> rho =
        Eigen::Matrix<double,-1,1>::Constant(J,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 12;
      rho = in__.template read_constrain_simplex<
              Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(lp__, J);
      Eigen::Matrix<double,-1,1> lambda_raw =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 13;
      lambda_raw = in__.template read<
                     Eigen::Matrix<local_scalar_t__,-1,1>>(N);
      double psi = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 14;
      psi = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
              lp__);
      std::vector<double> theta =
        std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> alpha0 =
        Eigen::Matrix<double,-1,-1>::Constant(N, 2,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,-1> beta0 =
        Eigen::Matrix<double,-1,-1>::Constant(N, 2,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(N_obs,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> lambda =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu_alpha =
        Eigen::Matrix<double,-1,1>::Constant(G,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> mu_beta =
        Eigen::Matrix<double,-1,1>::Constant(G,
          std::numeric_limits<double>::quiet_NaN());
      double eta_scale = std::numeric_limits<double>::quiet_NaN();
      out__.write(alpha_raw);
      out__.write(beta_raw);
      out__.write(theta_lr);
      out__.write(theta_raw);
      out__.write(mu_alpha_raw);
      out__.write(mu_beta_raw);
      out__.write(sigma_alpha);
      out__.write(sigma_beta);
      out__.write(nu);
      out__.write(tau);
      out__.write(eta);
      out__.write(rho);
      out__.write(lambda_raw);
      out__.write(psi);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 19;
      stan::model::assign(lambda,
        stan::math::inv_logit(
          stan::math::add(psi, stan::math::multiply(lambda_raw, 3))),
        "assigning variable lambda");
      current_statement__ = 20;
      stan::model::assign(mu_alpha,
        stan::math::multiply(
          stan::math::divide(
            stan::math::subtract(mu_alpha_raw, mean_mu_simplexes),
            sd_mu_simplexes), sigma_mu_alpha), "assigning variable mu_alpha");
      current_statement__ = 21;
      stan::model::assign(mu_beta,
        stan::math::multiply(
          stan::math::divide(
            stan::math::subtract(mu_beta_raw, mean_mu_simplexes),
            sd_mu_simplexes), sigma_mu_beta), "assigning variable mu_beta");
      current_statement__ = 22;
      eta_scale = (tau * J);
      current_statement__ = 28;
      stan::model::assign(theta, theta_raw, "assigning variable theta");
      current_statement__ = 29;
      stan::model::assign(theta,
        stan::model::rvalue(theta_lr, "theta_lr", stan::model::index_uni(1)),
        "assigning variable theta", stan::model::index_uni(L));
      current_statement__ = 30;
      stan::model::assign(theta,
        stan::model::rvalue(theta_lr, "theta_lr", stan::model::index_uni(2)),
        "assigning variable theta", stan::model::index_uni(R));
      current_statement__ = 36;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 31;
        stan::model::assign(alpha0,
          ((stan::model::rvalue(alpha_raw, "alpha_raw",
              stan::model::index_uni(i), stan::model::index_uni(1)) *
          sigma_alpha) +
          stan::model::rvalue(mu_alpha, "mu_alpha",
            stan::model::index_uni(
              stan::model::rvalue(gg, "gg", stan::model::index_uni(i))))),
          "assigning variable alpha0", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 32;
        stan::model::assign(alpha0,
          ((stan::model::rvalue(alpha_raw, "alpha_raw",
              stan::model::index_uni(i), stan::model::index_uni(2)) *
          sigma_alpha) +
          stan::model::rvalue(mu_alpha, "mu_alpha",
            stan::model::index_uni(
              stan::model::rvalue(gg, "gg", stan::model::index_uni(i))))),
          "assigning variable alpha0", stan::model::index_uni(i),
          stan::model::index_uni(2));
        current_statement__ = 33;
        stan::model::assign(beta0,
          stan::math::exp(
            ((stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_uni(i), stan::model::index_uni(1)) *
            sigma_beta) +
            stan::model::rvalue(mu_beta, "mu_beta",
              stan::model::index_uni(
                stan::model::rvalue(gg, "gg", stan::model::index_uni(i)))))),
          "assigning variable beta0", stan::model::index_uni(i),
          stan::model::index_uni(1));
        current_statement__ = 34;
        stan::model::assign(beta0,
          -stan::math::exp(
             (stan::model::rvalue(beta_raw, "beta_raw",
                stan::model::index_uni(i), stan::model::index_uni(2)) *
             sigma_beta)), "assigning variable beta0",
          stan::model::index_uni(i), stan::model::index_uni(2));
      }
      current_statement__ = 39;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 37;
        stan::model::assign(log_lik,
          stan::math::log_mix(
            stan::model::rvalue(lambda, "lambda",
              stan::model::index_uni(
                stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))),
            stan::math::normal_lpdf<false>(
              stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
              (stan::model::rvalue(alpha0, "alpha0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(1)) +
              (stan::model::rvalue(beta0, "beta0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(1)) *
              stan::model::rvalue(theta, "theta",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
              (stan::math::sqrt(
                 stan::model::rvalue(eta, "eta",
                   stan::model::index_uni(
                     stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
              *
              stan::model::rvalue(rho, "rho",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
            stan::math::normal_lpdf<false>(
              stan::model::rvalue(Y, "Y", stan::model::index_uni(n)),
              (stan::model::rvalue(alpha0, "alpha0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(2)) +
              (stan::model::rvalue(beta0, "beta0",
                 stan::model::index_uni(
                   stan::model::rvalue(ii, "ii", stan::model::index_uni(n))),
                 stan::model::index_uni(2)) *
              stan::model::rvalue(theta, "theta",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n)))))),
              (stan::math::sqrt(
                 stan::model::rvalue(eta, "eta",
                   stan::model::index_uni(
                     stan::model::rvalue(ii, "ii", stan::model::index_uni(n)))))
              *
              stan::model::rvalue(rho, "rho",
                stan::model::index_uni(
                  stan::model::rvalue(jj, "jj", stan::model::index_uni(n))))))),
          "assigning variable log_lik", stan::model::index_uni(n));
      }
      current_statement__ = 19;
      stan::math::check_greater_or_equal(function__, "lambda", lambda, 0);
      current_statement__ = 19;
      stan::math::check_less_or_equal(function__, "lambda", lambda, 1);
      current_statement__ = 22;
      stan::math::check_greater_or_equal(function__, "eta_scale", eta_scale,
        0);
      if (emit_transformed_parameters__) {
        out__.write(theta);
        out__.write(alpha0);
        out__.write(beta0);
        out__.write(log_lik);
        out__.write(lambda);
        out__.write(mu_alpha);
        out__.write(mu_beta);
        out__.write(eta_scale);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      double min_rho = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 23;
      min_rho = stan::math::min(rho);
      Eigen::Matrix<double,-1,1> kappa =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 24;
      stan::model::assign(kappa,
        stan::math::to_vector(stan::math::bernoulli_rng(lambda, base_rng__)),
        "assigning variable kappa");
      Eigen::Matrix<double,-1,1> alpha =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 25;
      stan::model::assign(alpha,
        stan::math::add(
          stan::math::elt_multiply(kappa,
            stan::model::rvalue(alpha0, "alpha0", stan::model::index_omni(),
              stan::model::index_uni(1))),
          stan::math::elt_multiply(stan::math::subtract(1, kappa),
            stan::model::rvalue(alpha0, "alpha0", stan::model::index_omni(),
              stan::model::index_uni(2)))), "assigning variable alpha");
      Eigen::Matrix<double,-1,1> beta =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 26;
      stan::model::assign(beta,
        stan::math::add(
          stan::math::elt_multiply(kappa,
            stan::model::rvalue(beta0, "beta0", stan::model::index_omni(),
              stan::model::index_uni(1))),
          stan::math::elt_multiply(stan::math::subtract(1, kappa),
            stan::model::rvalue(beta0, "beta0", stan::model::index_omni(),
              stan::model::index_uni(2)))), "assigning variable beta");
      Eigen::Matrix<double,-1,1> chi =
        Eigen::Matrix<double,-1,1>::Constant(N,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 27;
      stan::model::assign(chi,
        stan::math::elt_divide(
          stan::math::subtract(
            stan::math::subtract(V,
              stan::math::to_vector(
                stan::math::normal_rng(0,
                  stan::math::multiply(stan::math::sqrt(eta), min_rho),
                  base_rng__))), alpha), beta), "assigning variable chi");
      current_statement__ = 23;
      stan::math::check_greater_or_equal(function__, "min_rho", min_rho, 0);
      out__.write(min_rho);
      out__.write(kappa);
      out__.write(alpha);
      out__.write(beta);
      out__.write(chi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(alpha_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N, 2),
        "assigning variable alpha_raw");
      out__.write(alpha_raw);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      current_statement__ = 2;
      stan::model::assign(beta_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,-1>>(N, 2),
        "assigning variable beta_raw");
      out__.write(beta_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> theta_lr =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      current_statement__ = 3;
      stan::model::assign(theta_lr,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(2),
        "assigning variable theta_lr");
      out__.write_free_ordered(theta_lr);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(theta_raw,
        in__.read<std::vector<local_scalar_t__>>(J),
        "assigning variable theta_raw");
      out__.write(theta_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(mu_alpha_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(G),
        "assigning variable mu_alpha_raw");
      out__.write_free_simplex(mu_alpha_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      current_statement__ = 6;
      stan::model::assign(mu_beta_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(G),
        "assigning variable mu_beta_raw");
      out__.write_free_simplex(mu_beta_raw);
      local_scalar_t__ sigma_alpha = DUMMY_VAR__;
      current_statement__ = 7;
      sigma_alpha = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, sigma_alpha);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 8;
      sigma_beta = in__.read<local_scalar_t__>();
      out__.write_free_lub(0, 2, sigma_beta);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 9;
      nu = in__.read<local_scalar_t__>();
      out__.write_free_lub(3, 30, nu);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 10;
      tau = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 11;
      stan::model::assign(eta,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable eta");
      out__.write_free_lb(0, eta);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      current_statement__ = 12;
      stan::model::assign(rho,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(J),
        "assigning variable rho");
      out__.write_free_simplex(rho);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      current_statement__ = 13;
      stan::model::assign(lambda_raw,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(N),
        "assigning variable lambda_raw");
      out__.write(lambda_raw);
      local_scalar_t__ psi = DUMMY_VAR__;
      current_statement__ = 14;
      psi = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, psi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "alpha_raw",
        "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(2)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta_raw",
        "double",
        std::vector<size_t>{static_cast<size_t>(N), static_cast<size_t>(2)});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "theta_lr",
        "double", std::vector<size_t>{static_cast<size_t>(2)});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "theta_raw",
        "double", std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "mu_alpha_raw",
        "double", std::vector<size_t>{static_cast<size_t>(G)});
      current_statement__ = 6;
      context__.validate_dims("parameter initialization", "mu_beta_raw",
        "double", std::vector<size_t>{static_cast<size_t>(G)});
      current_statement__ = 7;
      context__.validate_dims("parameter initialization", "sigma_alpha",
        "double", std::vector<size_t>{});
      current_statement__ = 8;
      context__.validate_dims("parameter initialization", "sigma_beta",
        "double", std::vector<size_t>{});
      current_statement__ = 9;
      context__.validate_dims("parameter initialization", "nu", "double",
        std::vector<size_t>{});
      current_statement__ = 10;
      context__.validate_dims("parameter initialization", "tau", "double",
        std::vector<size_t>{});
      current_statement__ = 11;
      context__.validate_dims("parameter initialization", "eta", "double",
        std::vector<size_t>{static_cast<size_t>(N)});
      current_statement__ = 12;
      context__.validate_dims("parameter initialization", "rho", "double",
        std::vector<size_t>{static_cast<size_t>(J)});
      current_statement__ = 13;
      context__.validate_dims("parameter initialization", "lambda_raw",
        "double", std::vector<size_t>{static_cast<size_t>(N)});
      current_statement__ = 14;
      context__.validate_dims("parameter initialization", "psi", "double",
        std::vector<size_t>{});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      Eigen::Matrix<local_scalar_t__,-1,-1> alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> alpha_raw_flat__;
        current_statement__ = 1;
        alpha_raw_flat__ = context__.vals_r("alpha_raw");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 1;
            stan::model::assign(alpha_raw, alpha_raw_flat__[(pos__ - 1)],
              "assigning variable alpha_raw", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 1;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(alpha_raw);
      Eigen::Matrix<local_scalar_t__,-1,-1> beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,-1>::Constant(N, 2, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 2;
        beta_raw_flat__ = context__.vals_r("beta_raw");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 2;
            stan::model::assign(beta_raw, beta_raw_flat__[(pos__ - 1)],
              "assigning variable beta_raw", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 2;
            pos__ = (pos__ + 1);
          }
        }
      }
      out__.write(beta_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> theta_lr =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(2, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> theta_lr_flat__;
        current_statement__ = 3;
        theta_lr_flat__ = context__.vals_r("theta_lr");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 3;
          stan::model::assign(theta_lr, theta_lr_flat__[(pos__ - 1)],
            "assigning variable theta_lr", stan::model::index_uni(sym1__));
          current_statement__ = 3;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_ordered(theta_lr);
      std::vector<local_scalar_t__> theta_raw =
        std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      current_statement__ = 4;
      theta_raw = context__.vals_r("theta_raw");
      out__.write(theta_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_alpha_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> mu_alpha_raw_flat__;
        current_statement__ = 5;
        mu_alpha_raw_flat__ = context__.vals_r("mu_alpha_raw");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(mu_alpha_raw, mu_alpha_raw_flat__[(pos__ - 1)],
            "assigning variable mu_alpha_raw", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(mu_alpha_raw);
      Eigen::Matrix<local_scalar_t__,-1,1> mu_beta_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(G, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> mu_beta_raw_flat__;
        current_statement__ = 6;
        mu_beta_raw_flat__ = context__.vals_r("mu_beta_raw");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
          current_statement__ = 6;
          stan::model::assign(mu_beta_raw, mu_beta_raw_flat__[(pos__ - 1)],
            "assigning variable mu_beta_raw", stan::model::index_uni(sym1__));
          current_statement__ = 6;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(mu_beta_raw);
      local_scalar_t__ sigma_alpha = DUMMY_VAR__;
      current_statement__ = 7;
      sigma_alpha = context__.vals_r("sigma_alpha")[(1 - 1)];
      out__.write_free_lb(0, sigma_alpha);
      local_scalar_t__ sigma_beta = DUMMY_VAR__;
      current_statement__ = 8;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      out__.write_free_lub(0, 2, sigma_beta);
      local_scalar_t__ nu = DUMMY_VAR__;
      current_statement__ = 9;
      nu = context__.vals_r("nu")[(1 - 1)];
      out__.write_free_lub(3, 30, nu);
      local_scalar_t__ tau = DUMMY_VAR__;
      current_statement__ = 10;
      tau = context__.vals_r("tau")[(1 - 1)];
      out__.write_free_lb(0, tau);
      Eigen::Matrix<local_scalar_t__,-1,1> eta =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 11;
        eta_flat__ = context__.vals_r("eta");
        current_statement__ = 11;
        pos__ = 1;
        current_statement__ = 11;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 11;
          stan::model::assign(eta, eta_flat__[(pos__ - 1)],
            "assigning variable eta", stan::model::index_uni(sym1__));
          current_statement__ = 11;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(0, eta);
      Eigen::Matrix<local_scalar_t__,-1,1> rho =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(J, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> rho_flat__;
        current_statement__ = 12;
        rho_flat__ = context__.vals_r("rho");
        current_statement__ = 12;
        pos__ = 1;
        current_statement__ = 12;
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          current_statement__ = 12;
          stan::model::assign(rho, rho_flat__[(pos__ - 1)],
            "assigning variable rho", stan::model::index_uni(sym1__));
          current_statement__ = 12;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_simplex(rho);
      Eigen::Matrix<local_scalar_t__,-1,1> lambda_raw =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(N, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> lambda_raw_flat__;
        current_statement__ = 13;
        lambda_raw_flat__ = context__.vals_r("lambda_raw");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 13;
          stan::model::assign(lambda_raw, lambda_raw_flat__[(pos__ - 1)],
            "assigning variable lambda_raw", stan::model::index_uni(sym1__));
          current_statement__ = 13;
          pos__ = (pos__ + 1);
        }
      }
      out__.write(lambda_raw);
      local_scalar_t__ psi = DUMMY_VAR__;
      current_statement__ = 14;
      psi = context__.vals_r("psi")[(1 - 1)];
      out__.write_free_lb(0, psi);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"alpha_raw", "beta_raw", "theta_lr",
                "theta_raw", "mu_alpha_raw", "mu_beta_raw", "sigma_alpha",
                "sigma_beta", "nu", "tau", "eta", "rho", "lambda_raw", "psi"};
    if (emit_transformed_parameters__) {
      std::vector<std::string>
        temp{"theta", "alpha0", "beta0", "log_lik", "lambda", "mu_alpha",
             "mu_beta", "eta_scale"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string>
        temp{"min_rho", "kappa", "alpha", "beta", "chi"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(N),
                                                 static_cast<size_t>(2)},
                std::vector<size_t>{static_cast<size_t>(N),
                  static_cast<size_t>(2)},
                std::vector<size_t>{static_cast<size_t>(2)},
                std::vector<size_t>{static_cast<size_t>(J)},
                std::vector<size_t>{static_cast<size_t>(G)},
                std::vector<size_t>{static_cast<size_t>(G)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(N)},
                std::vector<size_t>{static_cast<size_t>(J)},
                std::vector<size_t>{static_cast<size_t>(N)},
                std::vector<size_t>{}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(J)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(2)},
             std::vector<size_t>{static_cast<size_t>(N),
               static_cast<size_t>(2)},
             std::vector<size_t>{static_cast<size_t>(N_obs)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(G)},
             std::vector<size_t>{static_cast<size_t>(G)},
             std::vector<size_t>{}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)},
             std::vector<size_t>{static_cast<size_t>(N)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "alpha_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_lr" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_alpha_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_beta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_alpha");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "psi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "alpha0" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta0" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambda" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_beta" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta_scale");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_rho");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "chi" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "alpha_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
        param_names__.emplace_back(std::string() + "beta_raw" + '.' +
          std::to_string(sym2__) + '.' + std::to_string(sym1__));
      }
    }
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_lr" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      param_names__.emplace_back(std::string() + "theta_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= (G - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_alpha_raw" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= (G - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_beta_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "sigma_alpha");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "nu");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "eta" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= (J - 1); ++sym1__) {
      param_names__.emplace_back(std::string() + "rho" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      param_names__.emplace_back(std::string() + "lambda_raw" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "psi");
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        param_names__.emplace_back(std::string() + "theta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "alpha0" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          param_names__.emplace_back(std::string() + "beta0" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "lambda" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= G; ++sym1__) {
        param_names__.emplace_back(std::string() + "mu_beta" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "eta_scale");
    }
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "min_rho");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "kappa" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "alpha" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "beta" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        param_names__.emplace_back(std::string() + "chi" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"theta_lr\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu_alpha_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"parameters\"},{\"name\":\"sigma_alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(J) + "},\"block\":\"parameters\"},{\"name\":\"lambda_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"alpha0\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"transformed_parameters\"},{\"name\":\"eta_scale\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"min_rho\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"alpha_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"theta_lr\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(2) + "},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"mu_alpha_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((G -1)) + "},\"block\":\"parameters\"},{\"name\":\"mu_beta_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((G -1)) + "},\"block\":\"parameters\"},{\"name\":\"sigma_alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"nu\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"rho\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string((J -1)) + "},\"block\":\"parameters\"},{\"name\":\"lambda_raw\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(J) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"alpha0\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(N) + ",\"cols\":" + std::to_string(2) + "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N_obs) + "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"transformed_parameters\"},{\"name\":\"mu_beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(G) + "},\"block\":\"transformed_parameters\"},{\"name\":\"eta_scale\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"min_rho\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(N) + "},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((((((((N * 2) + (N * 2)) + 2) + J) +
      G) + G) + 1) + 1) + 1) + 1) + N) + J) + N) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((((((J +
      (N * 2)) + (N * 2)) + N_obs) + N) + G) + G) + 1));
    const size_t num_gen_quantities = emit_generated_quantities * (((((1 + N)
      + N) + N) + N));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((((((((((((N * 2) + (N * 2)) + 2) + J) +
      G) + G) + 1) + 1) + 1) + 1) + N) + J) + N) + 1);
    const size_t num_transformed = emit_transformed_parameters * ((((((((J +
      (N * 2)) + (N * 2)) + N_obs) + N) + G) + G) + 1));
    const size_t num_gen_quantities = emit_generated_quantities * (((((1 + N)
      + N) + N) + N));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_HBAM_MULTI_namespace::model_HBAM_MULTI;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_HBAM_MULTI_namespace::profiles__;
}
#endif
#endif
