% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{select_helpers}
\alias{select_helpers}
\alias{all_continuous}
\alias{all_continuous2}
\alias{all_categorical}
\alias{all_dichotomous}
\alias{all_tests}
\alias{all_stat_cols}
\alias{all_interaction}
\alias{all_intercepts}
\alias{all_contrasts}
\title{Select helper functions}
\usage{
all_continuous(continuous2 = TRUE)

all_continuous2()

all_categorical(dichotomous = TRUE)

all_dichotomous()

all_tests(tests = NULL)

all_stat_cols(stat_0 = TRUE)

all_interaction()

all_intercepts()

all_contrasts(contrasts_type = NULL)
}
\arguments{
\item{continuous2}{Logical indicating whether to include continuous2 variables. Default is \code{TRUE}}

\item{dichotomous}{Logical indicating whether to include dichotomous variables.
Default is \code{TRUE}}

\item{tests}{string indicating the test type of the variables to select, e.g.
select all variables being compared with \code{"t.test"}}

\item{stat_0}{When \code{FALSE}, will not select the \code{"stat_0"} column. Default is \code{TRUE}}

\item{contrasts_type}{type of contrast to select. When \code{NULL}, all variables with a
contrast will be selected. Default is \code{NULL}.  Select among contrast types
\code{c("treatment", "sum", "poly", "helmert", "other")}}
}
\value{
A character vector of column names selected
}
\description{
Set of functions to supplement the {tidyselect} set of
functions for selecting columns of data frames (and other items as well).
\itemize{
\item \code{all_continuous()} selects continuous variables
\item \code{all_continuous2()} selects only type \code{"continuous2"}
\item \code{all_categorical()} selects categorical (including \code{"dichotomous"}) variables
\item \code{all_dichotomous()} selects only type \code{"dichotomous"}
\item \code{all_tests()} selects variables by the name of the test performed
\item \code{all_stat_cols()} selects columns from \code{tbl_summary}/\code{tbl_svysummary} object with summary statistics (i.e. \code{"stat_0"}, \code{"stat_1"}, \code{"stat_2"}, etc.)
\item \code{all_interaction()} selects interaction terms from a regression model
\item \code{all_intercepts()} selects intercept terms from a regression model
\item \code{all_contrasts()} selects variables in regression model based on their type of contrast
}
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/select_ex1.png" alt="image of rendered example table" style="width:55\%;">
}}
}

\examples{
select_ex1 <-
  trial \%>\%
  select(age, response, grade) \%>\%
  tbl_summary(
    statistic = all_continuous() ~ "{mean} ({sd})",
    type = all_dichotomous() ~ "categorical"
  )
}
\seealso{
Review \link[=syntax]{list, formula, and selector syntax} used throughout gtsummary
}
