% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_auto}
\alias{fmt_auto}
\title{Automatically format column data according to their values}
\usage{
fmt_auto(
  data,
  columns = everything(),
  rows = everything(),
  scope = c("numbers", "currency"),
  lg_num_pref = c("sci", "suf"),
  locale = NULL
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{columns}{\emph{Columns to target}

\code{\link[=rows-columns]{<column-targeting expression>}} // \emph{default:} \code{everything()}

Can either be a series of column names provided in \code{c()}, a vector of
column indices, or a select helper function (e.g. \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=num_range]{num_range()}} and \code{\link[=everything]{everything()}}).}

\item{rows}{\emph{Rows to target}

\code{\link[=rows-columns]{<row-targeting expression>}} // \emph{default:} \code{everything()}

In conjunction with \code{columns}, we can specify which of their rows should
undergo formatting. The default \code{\link[=everything]{everything()}} results in all rows in
\code{columns} being formatted. Alternatively, we can supply a vector of row
captions within \code{c()}, a vector of row indices, or a select helper
function (e.g. \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}). We can also use expressions to filter
down to the rows we need (e.g., \verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{scope}{\emph{Scope of automatic formatting}

\verb{mult-kw:[numbers|currency]} // \emph{default:} \code{c("numbers", "currency")}

By default, the function will format both \code{"numbers"}-type values and
\code{"currency"}-type values though the scope can be reduced to a single type
of value to format.}

\item{lg_num_pref}{\emph{Large-number preference}

\verb{singl-kw:[sci|suf]} // \emph{default:} \code{"sci"}

When large numbers are present, there can be a fixed preference toward how
they are formatted. Choices are scientific notation for very small and very
large values (\code{"sci"}), or, the use of suffixed numbers (\code{"suf"}, for large
values only).}

\item{locale}{\emph{Locale identifier}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional locale identifier that can be used for formatting values
according the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). We can call \code{\link[=info_locales]{info_locales()}} for a
useful reference for all of the locales that are supported. A locale ID can
be also set in the initial \code{\link[=gt]{gt()}} function call (where it would be used
automatically by any function with a \code{locale} argument) but a \code{locale}
value provided here will override that global locale.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
\code{fmt_auto()} will automatically apply formatting of various types in a way
that best suits the data table provided. The function will attempt to format
numbers such that they are condensed to an optimal width, either with
scientific notation or large-number suffixing. Currency values are detected
by currency codes embedded in the column name and formatted in the correct
way. Although the functionality here is comprehensive it's still possible to
reduce the scope of automatic formatting with the \code{scope} argument and also
by choosing a subset of columns and rows to which the formatting will be applied.
}
\section{Examples}{


Use the \code{\link{exibble}} dataset to create a \strong{gt} table. Format all of the
columns automatically with the \code{fmt_auto()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  gt() |>
  fmt_auto()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_auto_1.png" alt="This image of a table was generated from the first code example in the `fmt_auto()` help file." style="width:100\%;">
}}

Let's now use the \code{\link{countrypops}} dataset to create another \strong{gt} table.
We'll again use \code{fmt_auto()} to automatically format all columns but this
time the choice will be made to opt for large-number suffixing instead of
scientific notation. This is done by using the \code{lg_num_pref = "suf"} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops |>
  dplyr::select(country_code_3, year, population) |>
  dplyr::filter(country_code_3 \%in\% c("CHN", "IND", "USA", "PAK", "IDN")) |>
  dplyr::filter(year > 1975 & year \%\% 5 == 0) |>
  tidyr::spread(year, population) |>
  dplyr::arrange(desc(`2020`)) |>
  gt(rowname_col = "country_code_3") |>
  fmt_auto(lg_num_pref = "suf")
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_auto_2.png" alt="This image of a table was generated from the second code example in the `fmt_auto()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-29
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt}()},
\code{\link{fmt_bins}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_chem}()},
\code{\link{fmt_country}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_email}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_flag}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_icon}()},
\code{\link{fmt_image}()},
\code{\link{fmt_index}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_spelled_num}()},
\code{\link{fmt_tf}()},
\code{\link{fmt_time}()},
\code{\link{fmt_units}()},
\code{\link{fmt_url}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()}
}
\concept{data formatting functions}
