% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqs.R
\name{freqs}
\alias{freqs}
\alias{freqs.default}
\alias{freqs.Arma}
\alias{freqs.Ma}
\alias{freqs.Sos}
\alias{freqs.Zpg}
\alias{print.freqs}
\alias{summary.freqs}
\alias{print.summary.freqs}
\alias{freqs_plot}
\title{Frequency response of analog filters}
\usage{
freqs(filt, ...)

\method{freqs}{default}(filt, a, w, ...)

\method{freqs}{Arma}(filt, w, ...)

\method{freqs}{Ma}(filt, w, ...)

\method{freqs}{Sos}(filt, w, ...)

\method{freqs}{Zpg}(filt, w, ...)

\method{print}{freqs}(x, ...)

\method{summary}{freqs}(object, ...)

\method{print}{summary.freqs}(x, ...)

freqs_plot(x, ...)
}
\arguments{
\item{filt}{for the default case, moving average (MA) polynomial
coefficients, specified as a numeric vector or matrix. In case of a matrix,
then each row corresponds to an output of the system. The number of columns
of \code{b} must be less than or equal to the length of \code{a}.}

\item{...}{for methods of \code{freqs}, arguments are passed to the default
method. For \code{freqs_plot}, additional arguments are passed through to
plot.}

\item{a}{autoregressive (AR) polynomial coefficients, specified as a vector.}

\item{w}{angular frequencies, specified as a positive real vector expressed
in rad/second.}

\item{x}{object to be printed or plotted.}

\item{object}{object of class \code{"freqs"} for \code{summary}}
}
\value{
For \code{freqs}, a list of class \code{'freqs'} with items:
\describe{
  \item{h}{complex array of frequency responses at frequencies \code{f}.}
  \item{w}{array of frequencies.}
}
}
\description{
Compute the s-plane frequency response of an IIR filter.
}
\details{
The s-plane frequency response of the IIR filter \code{B(s) / A(s)} is
computed as \code{H = polyval(B, 1i * W) / polyval(A, 1i * W)}. If called
with no output argument, a plot of magnitude and phase are displayed.
}
\examples{
b <- c(1, 2); a <- c(1, 1)
w <- seq(0, 4, length.out = 128)
freqs (b, a, w)

}
\author{
Julius O. Smith III, \email{jos@ccrma.stanford.edu}.\cr
Conversion to R by Geert van Boxtel \email{gjmvanboxtel@gmail.com}
}
