% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtic.R
\name{filtic}
\alias{filtic}
\alias{filtic.default}
\alias{filtic.Arma}
\alias{filtic.Ma}
\alias{filtic.Sos}
\alias{filtic.Zpg}
\title{Filter Initial Conditions}
\usage{
filtic(filt, ...)

\method{filtic}{default}(filt, a, y, x = 0, ...)

\method{filtic}{Arma}(filt, y, x = 0, ...)

\method{filtic}{Ma}(filt, y, x = 0, ...)

\method{filtic}{Sos}(filt, y, x = 0, ...)

\method{filtic}{Zpg}(filt, y, x = 0, ...)
}
\arguments{
\item{filt}{For the default case, the moving-average coefficients of an ARMA
filter (normally called \code{b}), specified as a vector. Generically,
\code{filt} specifies an arbitrary filter operation.}

\item{...}{additional arguments (ignored).}

\item{a}{the autoregressive (recursive) coefficients of an ARMA filter.}

\item{y}{output vector, with the most recent values first.}

\item{x}{input vector, with the most recent values first. Default: 0}
}
\value{
Initial conditions for filter specified by \code{filt}, input vector
  \code{x}, and output vector \code{y}, returned as a vector.
}
\description{
Compute the initial conditions for a filter.
}
\details{
This function computes the same values that would be obtained from the
function \code{filter} given past inputs \code{x} and outputs \code{y}.

The vectors \code{x} and \code{y} contain the most recent inputs and outputs
respectively, with the newest values first:

\code{x = c(x(-1), x(-2), ... x(-nb)); nb = length(b)-1}\cr
\code{y = c(y(-1), y(-2), ... y(-na)); na = length(a)-a}

If \code{length(x) < nb} then it is zero padded. If \code{length(y) < na}
then it is zero padded.
}
\examples{
## Simple low pass filter
b <- c(0.25, 0.25)
a <- c(1.0, -0.5)
ic <- filtic(b, a, 1, 1)

## Simple high pass filter
b <- c(0.25, -0.25)
a <- c(1.0, 0.5)
ic <- filtic(b, a, 0, 1)

## Example from Python scipy.signal.lfilter() documentation
t <- seq(-1, 1, length.out =  201)
x <- (sin(2 * pi * 0.75 * t * (1 - t) + 2.1)
      + 0.1 * sin(2 * pi * 1.25 * t + 1)
      + 0.18 * cos(2 * pi * 3.85 * t))
h <- butter(3, 0.05)
l <- max(length(h$b), length(h$a)) - 1
zi <- filtic(h, rep(1, l), rep(1, l))
z <- filter(h, x, zi * x[1])

}
\seealso{
\code{\link{filter}}, \code{\link{sosfilt}}, \code{\link{filtfilt}},
\code{\link{filter_zi}}
}
\author{
David Billinghurst, \email{David.Billinghurst@riotinto.com}.\cr
  Adapted and converted to R by Geert van Boxtel
  \email{G.J.M.vanBoxtel@gmail.com}.
}
