% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digitrevorder.R
\name{digitrevorder}
\alias{digitrevorder}
\title{Permute input to digit-reversed order}
\usage{
digitrevorder(x, r, index.return = FALSE)
}
\arguments{
\item{x}{input data, specified as a vector. The length of \code{x} must be an
integer power of \code{r}.}

\item{r}{radix base used for the number conversion, which can be any integer
from 2 to 36. The elements of \code{x} are converted to radix \code{r} and
reversed.}

\item{index.return}{logical indicating if the ordering index vector should be
returned as well. Default \code{FALSE}.}
}
\value{
The digit-reversed input vector. If \code{index.return = TRUE}, then
  a list containing the digit-reversed input vector (\code{y}, and the
  digit-reversed indices (\code{i}).
}
\description{
Reorder the elements of the input vector in digit-reversed order.
}
\details{
This function is useful for pre-ordering a vector of filter coefficients for
use in frequency-domain filtering algorithms, in which the fft and ifft
transforms are computed without digit-reversed ordering for improved run-time
efficiency.
}
\examples{

res <- digitrevorder(0:8, 3)

}
\seealso{
\code{\link{bitrevorder}}, \code{\link{fft}}, \code{\link{ifft}}
}
\author{
Mike Miller.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
