% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{peay_average_path_value}
\alias{peay_average_path_value}
\title{Yang and Knoke's Average Path Value}
\usage{
peay_average_path_value(sociomatrix, path)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}
}
\description{
Calculates 'APV' (Average Path Value) as defined in Yang, Knoke (2001)
Called \code{peay_average_path_value} in homage to E.R. Peay, who defined 
path length in 1980.
}
\examples{
## Calculate 'APV' of a path in a sociomatrix
peay_average_path_value(YangKnoke01, path = c(1,2,5))

## This path doesn't exist
peay_average_path_value(YangKnoke01, path = c(1,2,4,5))

}
\seealso{
\code{\link{peay_path_value}}
}
