% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{flament_path_length}
\alias{flament_path_length}
\title{Flament's Path Length Measure}
\usage{
flament_path_length(sociomatrix, path)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}
}
\description{
Calculates path length as defined in Flament (1963). That is, sums the
values of each edge in the path, if all edges exist. Otherwise, returns \code{NA}.
}
\examples{
## Calculate Flament's Path Length along a path in a sociomatrix
flament_path_length(YangKnoke01, path = c(1,2,5))

## This path doesn't exist
flament_path_length(YangKnoke01, path = c(1,2,4,5))

}
\seealso{
\code{\link{flament_average_path_length}}
}
