% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametric-effects.R
\name{draw.parametric_effects}
\alias{draw.parametric_effects}
\title{Plot estimated effects for model parametric terms}
\usage{
\method{draw}{parametric_effects}(
  object,
  scales = c("free", "fixed"),
  ci_level = 0.95,
  ci_col = "black",
  ci_alpha = 0.2,
  line_col = "black",
  constant = NULL,
  fun = NULL,
  rug = TRUE,
  position = "identity",
  angle = NULL,
  ...,
  ncol = NULL,
  nrow = NULL,
  guides = "keep"
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? If \code{scales = "free"}, the default, each univariate
smooth has its own y-axis scale. If \code{scales = "fixed"}, a common y axis
scale is used for all univariate smooths.

Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{line_col}{colour specification used for regression lines of linear
continuous terms.}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{rug}{logical; draw a rug plot at the botom of each plot for 1-D
smooths or plot locations of data for higher dimensions.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{angle}{numeric; the angle at which the x axis tick labels are to be
drawn passed to the \code{angle} argument of \code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}}.}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}
}
\description{
Plot estimated effects for model parametric terms
}
