% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimParam.R
\name{fitSimpleSBM}
\alias{fitSimpleSBM}
\title{Fit a stochastic block model to every network in a collection of networks.}
\usage{
fitSimpleSBM(
  allAdj,
  directed = TRUE,
  nbSBMBlocks = Inf,
  nbCores = 1,
  outCountStat = TRUE
)
}
\arguments{
\item{allAdj}{list of adjacency matrices}

\item{directed}{Networks are directed (TRUE by default) or undirected (FALSE).}

\item{nbSBMBlocks}{upper bound for the number of blocks in the SBMs of the mixture components. Default is Inf}

\item{nbCores}{number of cores for parallelization.}

\item{outCountStat}{If TRUE (default), the output is a list of count
statistics for every network. If FALSE, the output is a list of parameters of
the stochastic block models fitted to every network.}
}
\value{
list of count statistics for every network or list of parameters of
the stochastic block models fitted to every network.
}
\description{
Applies the variational EM-algorithm implemented in the package blockmodels to every network.
}
\examples{
theta <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
obs <- rCollectSBM(rep(10,4), theta)$listGraphs
res <- fitSimpleSBM(obs, outCountStat=FALSE, nbCores=2)
}
