% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai_gpt_queries.R
\name{gpt_chat}
\alias{gpt_chat}
\title{ChatGPT in RStudio}
\usage{
gpt_chat(
  history,
  style = getOption("gptstudio.code_style"),
  skill = getOption("gptstudio.skill"),
  model = getOption("gptstudio.model")
)
}
\arguments{
\item{history}{A list of the previous chat responses}

\item{style}{A character string indicating the preferred coding style, the
default is "tidyverse".}

\item{skill}{The self-described skill level of the programmer,
default is "beginner"}

\item{model}{The name of the GPT model to use.}
}
\value{
A list containing the instructions for answering the question, the
context in which the question was asked, and the suggested answer.
}
\description{
This function uses the ChatGPT API tailored to a user-provided style and
skill level.
}
\examples{
\dontrun{
# Example 1: Get help with a tidyverse question
tidyverse_query <- "How can I filter rows of a data frame?"
tidyverse_response <- gpt_chat(
  query = tidyverse_query,
  style = "tidyverse",
  skill = "beginner"
)
print(tidyverse_response)

# Example 2: Get help with a base R question
base_r_query <- "How can I merge two data frames?"
base_r_response <- gpt_chat(
  query = base_r_query,
  style = "base",
  skill = "intermediate"
)
print(base_r_response)

# Example 3: No style preference
no_preference_query <- "What is the best way to handle missing values in R?"
no_preference_response <- gpt_chat(
  query = no_preference_query,
  style = "no preference",
  skill = "advanced"
)
print(no_preference_response)
}
}
