% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_palm_makersuite.R
\name{create_completion_palm}
\alias{create_completion_palm}
\title{Generate text completions using PALM (MakerSuite)'s API}
\usage{
create_completion_palm(
  prompt,
  model = "text-bison-001",
  key = Sys.getenv("PALM_API_KEY"),
  temperature = 0.5,
  candidate_count = 1
)
}
\arguments{
\item{prompt}{The prompt for generating completions}

\item{model}{The model to use for generating text. By default, the
function will try to use "text-bison-001"}

\item{key}{The API key for accessing PALM (MakerSuite)'s API. By default, the
function will try to use the \code{PALM_API_KEY} environment variable.}

\item{temperature}{The temperature to control the randomness of the model's output}

\item{candidate_count}{The number of completion candidates to generate}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using PALM (MakerSuite)'s API
}
\examples{
\dontrun{
create_completion_palm(
  prompt = list(text = "Write a story about a magic backpack"),
  temperature = 1.0,
  candidate_count = 3
)
}
}
