% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpus.R
\name{gce_list_gpus}
\alias{gce_list_gpus}
\title{Retrieves a list GPUs you can attach to an instance}
\usage{
gce_list_gpus(
  filter = NULL,
  maxResults = NULL,
  pageToken = NULL,
  project = gce_get_global_project(),
  zone = gce_get_global_zone()
)
}
\arguments{
\item{filter}{Sets a filter expression for filtering listed resources, in the form filter={expression}}

\item{maxResults}{The maximum number of results per page that should be returned}

\item{pageToken}{Specifies a page token to use}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}
}
\description{
Retrieves a list GPUs you can attach to an instance
}
\details{
To filter you need a single string in the form \code{field_name eq|ne string} 
  e.g. \code{gce_list_instances("status eq RUNNING")} where \code{eq} is 'equals' and \code{ne} is 'not-equals'.
}
\seealso{
\href{https://cloud.google.com/compute/docs/gpus/#introduction}{GPUs on Compute Engine}

Other GPU instances: 
\code{\link{gce_check_gpu}()},
\code{\link{gce_vm_gpu}()}
}
\concept{GPU instances}
