% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/users.R
\name{ga_users_update}
\alias{ga_users_update}
\title{Update a user access in Google Analytics}
\usage{
ga_users_update(
  linkId,
  update_object,
  accountId,
  webPropertyId = NULL,
  viewId = NULL
)
}
\arguments{
\item{linkId}{The linkId to update}

\item{update_object}{A list that will be turned into JSON that represents the new configuration for this linkId}

\item{accountId}{Account Id}

\item{webPropertyId}{Web Property Id - set to NULL to operate on account level only}

\item{viewId}{viewId - set to NULL to operate on webProperty level only}
}
\value{
The new user object that has been altered.
}
\description{
This is for altering existing user access.
}
\examples{

\dontrun{

library(googleAnalyticsR)
ga_auth()

# the update to perform
o <- list(permissions = list(local = list("EDIT")))

ga_users_update("UA-123456-1:1111222233334444",
                update_object = o,
                accountId = 47480439,
                webPropertyId = "UA-123456-1")
                
}
}
\seealso{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/user-management}{Google help article on user permissions}

Other User management functions: 
\code{\link{ga_users_add}()},
\code{\link{ga_users_delete}()},
\code{\link{ga_users_delete_linkid}()},
\code{\link{ga_users_list}()}
}
\concept{User management functions}
