% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeSets.R
\name{writeSets}
\alias{writeSets}
\title{writeSets}
\usage{
writeSets(sets, file = NULL)
}
\arguments{
\item{sets}{a list of sets where every set is another list consisting of 
three entries: name (set name as character), desc (set description as 
character) and items (set elements, either as character vector or data.frame)}

\item{file}{Name of the file the set declarations should be written to. If
NULL the result will just be returned by the function. The file must exist
and contain a line of the form "##### R SECTION START (SETS) #####"
followed by a line of the form ##### R SECTION END (SETS) ##### to indicate
the part of the file that should be replaced with the set declaration!}
}
\value{
set declaration in GAMS syntax
}
\description{
Function to write a set declaration in GAMS syntax given either a
a character vector or a data.frame (latter to represent a mapping set)
}
\examples{
countries <- c("DEU", "FRA", "ENG", "ITA", "NLD", "POL")
map <- data.frame(region = rep(c("REG1","REG2"), 3), countries = countries)
sets <- list(list(name  = "countries", 
                  desc  = "list of countries", 
                  items = countries),
             list(name = "country2region",
                  desc = "mapping between countries and regions",
                  items = map))
 cat(writeSets(sets), sep="\n")
}
\author{
Jan Philipp Dietrich, Florian Humpenöder
}
