% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmo.R
\name{gmo}
\alias{gmo}
\title{Gradient-based marginal optimization}
\usage{
gmo(file, local_file, full_model, data, method = c("laplace"),
  init = "random", draws = 5L, iter = 100L, inner_iter = 10L,
  cond_iter = NA, eta = 1, tol = 0.001, seed = 1234L)
}
\arguments{
\item{file}{A character string or a connection that R supports specifying the
Stan model specification in Stan's modeling language.}

\item{local_file}{A character string or a connection that R supports specifying the
Stan model specification in Stan's modeling language.}

\item{full_model}{If provided, an object of class 'stanfit' that makes it unnecessary
to pass 'file' or 'local_file'}

\item{data}{A named ‘list’ or ‘environment’ providing the data for the model
or a character vector for all the names of objects used as data.
See \code{\link[rstan]{stan}} for more details.}

\item{method}{A character string naming the conditional inference:
"laplace"}

\item{init}{A numeric vector of length the number of hyperparameters.}

\item{draws}{A positive integer, number of draws to calculate stochastic gradient.}

\item{iter}{A positive integer, the maximum number of iterations.}

\item{inner_iter}{A positive integer, the number of iterations after each
conditional inference.}

\item{cond_iter}{A positive integer, the maximum number of iterations for the
conditional inference. Default is to run until convergence.}

\item{eta}{Double, constant scale factor for learning rate.}

\item{tol}{Double, tolerance for signaling convergence.}

\item{seed}{The seed, a positive integer, for random number generation of
Stan. The default is generated from 1 to the maximum integer
supported by R so fixing the seed of R's random number generator
can essentially fix the seed of Stan.  When multiple chains are
used, only one seed is needed, with other chains' seeds being
generated from the first chain's seed to prevent dependency among
the random number streams for the chains. When a seed is
specified by a number, ‘as.integer’ will be applied to it.  If
‘as.integer’ produces ‘NA’, the seed is generated randomly.  We
can also specify a seed using a character string of digits, such
as ‘"12345"’, which is converted to integer.}
}
\value{
An object of reference class \code{"gmo"}. It is a list containing
the following components:
\item{par}{a vector of optimized parameters}
\item{cov}{estimated covariance matrix at \code{par}}
\item{sims}{\code{draws * inner_iter} many samples from the last
    approximation to the conditional posterior, p(alpha | y, phi)}
}
\description{
Maximize the marginal posterior with respect to specified
parameters, with nuisance parameters marginalized out.
}

