% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{uti}
\alias{uti}
\title{Urinary Tract Infections in HIV-infected Men}
\format{
A data frame with 98 rows and 3 variables:
\describe{
  \item{episodes}{a numeric vector indicating the number of episodes, that is, the number of times each patient had urinary tract infections (UTI).}
  \item{time}{a numeric vector indicating the time to follow up, in months.}
  \item{cd4}{a numeric vector indicating the immune status of the patient as measured by the CD4+ cell counts.}
}
}
\usage{
data(uti)
}
\description{
These data arose from a study conducted in the Department
of Internal Medicine at Utrecht University Hospital, in the
Netherlands. In this study, 98 HIV-infected men were followed for
up to two years. Urinary cultures were obtained during the first
visit and every six months thereafter. Also, cultures were obtained
between regular scheduled visits when signs and symptoms of urinary
tract infections (UTI) occurred, or when patients had a fever of
unknown origin. CD4+ cell counts were also measured. A CD4+ count
is a blood test to determine how well the immune system works in
people diagnosed with HIV. In general, a decreasing CD4+ count
indicates HIV progression.
}
\examples{
data(uti)
dev.new()
uti2 <- within(uti,cd4C <- cut(log(cd4),4,labels=c("low","mid-low","mid-high","high")))
out <- aggregate(cbind(episodes,time) ~ cd4C, sum, data=uti2)
barplot(12*episodes/time ~ cd4C, beside=TRUE, data=out, col="red",
        xlab="CD4+ cell count", ylab="Number of UTIs per year")

}
\references{
Hoepelman A.I.M., Van Buren M., Van den Broek J., Borleffs J.C.C. (1992) Bacteriuria
in men infected with HIV-1 is related to their immune status (CD4+ cell count). \emph{AIDS} 6:179-184.

Morel J.G., Nagaraj N.K. (2012) \emph{Overdispersion Models in SAS}. SAS Institute Inc.,
Cary, North Carolina, USA.

van den Broek J. (1995) A Score Test for Zero Inflation in a Poisson Distribution.
\emph{Biometrics} 51:738–743.
}
\keyword{datasets}
