% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{pipeline}
\alias{pipeline}
\title{Alaska pipeline}
\format{
A data frame with 107 rows and 2 variables:
\describe{
  \item{Field}{a numeric vector indicating the number of defects measured in the field.}
  \item{Lab}{a numeric vector indicating the number of defects measured in the laboratory.}
}
}
\source{
\url{https://www.itl.nist.gov/div898/handbook/pmd/section6/pmd621.htm}
}
\usage{
data(pipeline)
}
\description{
The Alaska pipeline data consists of in-field ultrasonic measurements of
the depths of defects in the Alaska pipeline. The depth of the defects were then
re-measured in the laboratory. These measurements were performed in six different
batches. The data were analyzed to calibrate the bias of the field measurements
relative to the laboratory measurements. In this analysis, the field measurement
is the response variable and the laboratory measurement is the predictor variable.
}
\examples{
data(pipeline)
dev.new()
xlab <- "In-laboratory measurements"
ylab <- "In-field measurements"
with(pipeline,plot(Lab,Field,pch=20,xlab=xlab,ylab=ylab))
}
\references{
Weisberg S. (2005). \emph{Applied Linear Regression}, 3rd edition. Wiley, New York.
}
\keyword{datasets}
