% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6covariance.R
\name{Covariance}
\alias{Covariance}
\title{R6 Class representing a covariance function and data}
\description{
R6 Class representing a covariance function and data

R6 Class representing a covariance function and data
}
\details{
For the generalised linear mixed model

\deqn{Y \sim F(\mu,\sigma)}
\deqn{\mu = h^-1(X\beta + Z\gamma)}
\deqn{\gamma \sim MVN(0,D)}

where h is the link function, this class defines Z and D. The covariance is defined by a covariance function, data, and parameters.
A new instance can be generated with $new(). The class will generate the
relevant matrices Z and D automatically. See \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a
detailed guide on model specification.


**Intitialisation**
A covariance function is specified as an additive formula made up of
components with structure \code{(1|f(j))}. The left side of the vertical bar
specifies the covariates in the model that have a random effects structure.
The right side of the vertical bar specify the covariance function `f` for
that term using variable named in the data `j`.
Covariance functions on the right side of the vertical bar are multiplied
together, i.e. \code{(1|f(j)*g(t))}.

There are several common functions included for a named variable in data \code{x}.
A non-exhaustive list (see \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a full list):
* \code{gr(x)}: Indicator function (1 parameter)
* \code{fexp(x)}: Exponential function (2 parameters)
* \code{ar(x)}: AR function (2 parameters)
* \code{sqexp(x)}: Squared exponential (1 parameter)
* \code{matern(x)}: Matern function (2 parameters)
* \code{bessel(x)}: Modified Bessel function of the 2nd kind (1 parameter)
For many 2 parameter functions, such as `ar` and `fexp`, alternative one parameter 
versions are also available as `ar0` and `fexp0`. These function omit the variance 
parameter and so can be used in combination with `gr` functions such as `gr(j)*ar0(t)`.

Parameters are provided to the covariance function as a vector.
The parameters in the vector for each function should be provided
in the order the covariance functions are written are written.
For example,
* Formula: `~(1|gr(j))+(1|gr(j*t))`; parameters: `c(0.05,0.01)`
* Formula: `~(1|gr(j)*fexp0(t))`; parameters: `c(0.05,0.5)`

Updating of parameters is automatic if using the `update_parameters()` member function.


Using `update_parameters()` is the preferred way of updating the parameters of the
mean or covariance objects as opposed to direct assignment, e.g. `self$parameters <- c(...)`.
The function calls check functions to automatically update linked matrices with the new parameters.
If using direct assignment, call `self$check()` afterwards.
}
\examples{

## ------------------------------------------------
## Method `Covariance$new`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.25,0.7),
                      data= df)

## ------------------------------------------------
## Method `Covariance$check`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.15,0.8),
                      data= df)
cov$parameters <- c(0.25,0.1)
cov$check(verbose=FALSE)

## ------------------------------------------------
## Method `Covariance$print`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.05,0.8),
                      data= df)

## ------------------------------------------------
## Method `Covariance$subset`
## ------------------------------------------------

df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$subset(1:100)
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{Data frame with data required to build covariance}

\item{\code{formula}}{Covariance function formula.}

\item{\code{parameters}}{Model parameters specified in order of the functions in the formula.}

\item{\code{Z}}{Design matrix}

\item{\code{D}}{Covariance matrix of the random effects}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Covariance-n}{\code{Covariance$n()}}
\item \href{#method-Covariance-new}{\code{Covariance$new()}}
\item \href{#method-Covariance-check}{\code{Covariance$check()}}
\item \href{#method-Covariance-update_parameters}{\code{Covariance$update_parameters()}}
\item \href{#method-Covariance-print}{\code{Covariance$print()}}
\item \href{#method-Covariance-subset}{\code{Covariance$subset()}}
\item \href{#method-Covariance-get_chol_D}{\code{Covariance$get_chol_D()}}
\item \href{#method-Covariance-log_likelihood}{\code{Covariance$log_likelihood()}}
\item \href{#method-Covariance-simulate_re}{\code{Covariance$simulate_re()}}
\item \href{#method-Covariance-sparse}{\code{Covariance$sparse()}}
\item \href{#method-Covariance-parameter_table}{\code{Covariance$parameter_table()}}
\item \href{#method-Covariance-clone}{\code{Covariance$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-n"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-n}{}}}
\subsection{Method \code{n()}}{
Return the size of the design
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$n()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Scalar
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-new"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-new}{}}}
\subsection{Method \code{new()}}{
Create a new Covariance object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$new(formula, data = NULL, parameters = NULL, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{Formula describing the covariance function. See Details}

\item{\code{data}}{(Optional) Data frame with data required for constructing the covariance.}

\item{\code{parameters}}{(Optional) Vector with parameter values for the functions in the model
formula. See Details.}

\item{\code{verbose}}{Logical whether to provide detailed output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Covariance object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.25,0.7),
                      data= df)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-check"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-check}{}}}
\subsection{Method \code{check()}}{
Check if anything has changed and update matrices if so.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$check(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical whether to report if any changes detected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.15,0.8),
                      data= df)
cov$parameters <- c(0.25,0.1)
cov$check(verbose=FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-update_parameters"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-update_parameters}{}}}
\subsection{Method \code{update_parameters()}}{
Updates the covariance parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$update_parameters(parameters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameters}}{A vector of parameters for the covariance function(s). See Details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-print"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-print}{}}}
\subsection{Method \code{print()}}{
Show details of Covariance object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.05,0.8),
                      data= df)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-subset"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-subset}{}}}
\subsection{Method \code{subset()}}{
Keep specified indices and removes the rest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$subset(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{vector of indices to keep}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar0(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$subset(1:100)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-get_chol_D"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-get_chol_D}{}}}
\subsection{Method \code{get_chol_D()}}{
Returns the Cholesky decomposition of the covariance matrix D
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$get_chol_D()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-log_likelihood"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-log_likelihood}{}}}
\subsection{Method \code{log_likelihood()}}{
The function returns the values of the multivariate Gaussian log likelihood
with mean zero and covariance D for a given vector of random effect terms.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$log_likelihood(u)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{u}}{Vector of random effects}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value of the log likelihood
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-simulate_re"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-simulate_re}{}}}
\subsection{Method \code{simulate_re()}}{
Simulates a set of random effects from the multivariate Gaussian distribution
with mean zero and covariance D.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$simulate_re()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A vector of random effect values
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-sparse"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-sparse}{}}}
\subsection{Method \code{sparse()}}{
If this function is called then sparse matrix methods will be used for calculations
involving D
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$sparse(sparse = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sparse}}{Logical. Whether to use sparse methods (TRUE) or not (FALSE)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
None. Called for effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-parameter_table"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-parameter_table}{}}}
\subsection{Method \code{parameter_table()}}{
Returns a table showing which parameters are members of which covariance
function term.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$parameter_table()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
