% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{rControl}
\alias{rControl}
\title{Control of Latent Factor Model Number Estimation

Constructs the control structure for the estimation of the 
number of latent factors (r) for use within the \code{glmmPen_FA} and
\code{glmm_FA} estimation procedures.}
\usage{
rControl(r = NULL, r_max = NULL, r_est_method = "GR", size = 25)
}
\arguments{
\item{r}{positive integer specifying number of latent common factors to assume 
in the model. If \code{NULL} (default), this value estimated from the data. See 
\code{r_est_method} for available estimation procedures, and the Details
section for further details on the general estimation procedure.}

\item{r_max}{positive integer specifying maximum number of latent factors to consider.
If \code{NULL} (default), this value is automatically calculated.}

\item{r_est_method}{character string indicating method used to estimate number
of latent factors \code{r}. Default "GR" uses the Growth Ratio method of
Ahn and Horenstein (2013) (<doi:10.3982/ECTA8968>). 
Other available options include "ER" for
the Eigenvalue Ratio method of Ahn and Horenstein (2013) (<doi:10.3982/ECTA8968>) 
and "BN1" or "BN2",
the Bai and Ng (2002) method (<dio:10.1111/1468-0262.00273>) using one of two penalties: 
(1) \code{(d + p) / (d p) log(d p/(d+p))} or
(2) \code{(d + p) / (d p) log(min(d,p))} where d is the number of groups in
the data and p is the number of total random effect covariates (including the intercept)}

\item{size}{positive integer specifying the total number of pseudo random
effect estimates to use in the estimation procedure for the number of latent factors
r, which is restricted to be no less than 25. If this \code{size} is greater
than the number of groups in the data (i.e.~the number of levels of the grouping
variable), then a sampling procedure is used to increase the number of pseudo estimates
to the value of \code{size}.}
}
\description{
Control of Latent Factor Model Number Estimation

Constructs the control structure for the estimation of the 
number of latent factors (r) for use within the \code{glmmPen_FA} and
\code{glmm_FA} estimation procedures.
}
\details{
Estimation of \code{r} procedure: For each level of the group variable separately,
we identify the observations within that group and 
fit a regular penalized generalized linear model where the penalty value is the
minimum fixed effect penalty. These group-specific estimates, which we label as 'pseudo random effects',
are placed into a matrix \code{G}
(rows = number of levels of the grouping variable, columns = number of random effect covariates),
and this pseudo random effects matrix is treated as the observed outcome matrix used in
the "GR", "ER", and "BN" estimatino procedures described above in the description of \code{r_est_method}.
}
