% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.r
\docType{data}
\name{gss08}
\alias{gss08}
\title{General Social Study (GSS) 2008}
\format{
A data frame with 355 observations on 11 variables.
\describe{
\item{\code{DEFECT}}{If there is a strong chance of serious defect in the baby?}
\item{\code{HLTH}}{If the womans own health is seriously endangered by the pregnancy?}
\item{\code{RAPE}}{If she became pregnant as a result of rape?}
\item{\code{POOR}}{If the family has a very low income and cannot afford any more children?}
\item{\code{SINGLE}}{If she is not married and does not want to marry the man?}
\item{\code{NOMORE}}{If she is married and does not want any more children?}
\item{\code{AGE}}{Respondent's age}
\item{\code{SEX}}{Respondent's race}
\item{\code{RACE}}{Respondent's sex}
\item{\code{REGION}}{Region of interview}
\item{\code{DEGREE}}{Respondent's degree}
}
}
\source{
\url{https://gss.norc.org/}
}
\description{
This dataset includes 6 manifest items about abortion and several covariates from 355 respondents to the 2008 General Social Survey. Respondents answer the questions whether or not think it should be possible for a pregnant woman to obtain a legal abortion. The covariates include age, sex, race, region, and degree of respondents.
}
\examples{
data("gss08")
# Model 1: LCA
lca = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
           data = gss08, nclass = 3)
summary(lca)

# Model 2: LCA with a covariate
lcr = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ SEX,
           data = gss08, nclass = 3)
summary(lcr)
coef(lcr)

# Model 3: MGLCA
mglca = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
             group = REGION, data = gss08, nclass = 3)

# Model 4: MGLCA with covariates
summary(mglca)
mglcr = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ AGE,
             group = SEX, data = gss08, nclass = 3)
summary(mglcr)
coef(mglcr)
}
\references{
Smith, Tom W, Peter Marsden, Michael Hout, and Jibum Kim. General Social Surveys, 2008/Principal Investigator, Tom W. Smith; Co-Principal Investigator, Peter V. Marsden; Co-Principal Investigator, Michael Hout; Sponsored by National Science Foundation. -NORC ed.- Chicago: NORC at the University of Chicago
}
\keyword{datasets}
