% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{abc}
\alias{abc}
\title{Approximate Bayesian computation inference}
\usage{
abc(
  x,
  N,
  model = c("gk", "generalised_gh", "tukey_gh", "gh"),
  logB = FALSE,
  rprior,
  M,
  sumstats = c("all order statistics", "octiles", "moment estimates"),
  silent = FALSE
)
}
\arguments{
\item{x}{Vector of observations.}

\item{N}{Number of iterations to perform.}

\item{model}{Which model to check: "gk", "generalised_gh" or "tukey_gh".
For backwards compatibility, "gh" acts the same as "generalised_gh".}

\item{logB}{When true, the second parameter is log(B) rather than B.}

\item{rprior}{A function with single argument, n, which returns a matrix with n rows consisting of samples from the prior distribution for 4 parameters e.g. (A,B,g,k).}

\item{M}{Number of simulations to accept.}

\item{sumstats}{Which summary statistics to use.}

\item{silent}{When \code{FALSE} (the default) a progress bar is shown.}
}
\value{
Matrix whose rows are accepted parameter estimates plus a column giving the ABC distances.
}
\description{
Approximate Bayesian computation (ABC) inference for the g-and-k or g-and-h distribution.
}
\details{
This function performs approximate Bayesian inference for iid data from a g-and-k or g-and-h distribution, avoiding expensive density calculations.
The algorithm samples many parameter vectors from the prior and simulates corresponding data from the model.
The parameters are accepted or rejected based on how similar the simulations are to the observed data.
Similarity is measured using weighted Euclidean distance between summary vectors of the simulations and observations.
Several summaries can be used, including the complete order statistics or summaries based on octiles.
In the latter case only the corresponding order statistics are simulated, speeding up the method.
}
\examples{
set.seed(1)
x = rgk(10, A=3, B=1, g=2, k=0.5) ##An unusually small dataset for fast execution of this example
rprior = function(n) { matrix(runif(4*n,0,10), ncol=4) }
abc(x, N=1E4, rprior=rprior, M=100)
}
\references{
D. Prangle. gk: An R package for the g-and-k and generalised g-and-h distributions, 2017.
}
