% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/git_branch.R
\name{git_merge}
\alias{git_merge}
\title{Merge Branch into Current Branch}
\usage{
git_merge(branchname = NULL)
}
\arguments{
\item{branchname}{Name of other branch to merge into the current one, will be asked
interactively if left as NULL.}
}
\value{
Invisible NULL
}
\description{
Merge a different branch into the current branch. The user is asked interactively
to delete the merged (and now expendable) branch, and any conflicts arising are
printed and the option given to open the files immediately for editing. Any
files which resulted in conflicts will be flagged by \code{git_add()} to remind
the user to manually confirm conflicts are resolved.
}
\details{
A very helpful tool in RStudio is \code{Edit} -> \verb{Find in Files...} which allows
you to search your entire repository for where the conflicts are. These are
identified by searching for the chevrons <<<

Conflicts are the usual format for git and may also happen after \code{git_pull()}

\preformatted{
<<<<<<< HEAD
code-from-the-branch-you-have-stayed-on
=======
code-from-the-branch-you-have-just-merged-and-deleted
>>>>>>> merged-and-deleted-branch-name
}
}
