% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_tree.R
\name{geom_tree}
\alias{geom_tree}
\title{geom_tree}
\usage{
geom_tree(
  mapping = NULL,
  data = NULL,
  layout = "rectangular",
  multiPhylo = FALSE,
  continuous = "none",
  position = "identity",
  ...
)
}
\arguments{
\item{mapping}{aesthetic mapping}

\item{data}{data of the tree}

\item{layout}{one of 'rectangular', 'dendrogram', 'slanted', 'ellipse', 'roundrect',
'fan', 'circular', 'inward_circular', 'radial', 'equal_angle', 'daylight' or 'ape'}

\item{multiPhylo}{logical, whether input data contains multiple phylo class, defaults to "FALSE".}

\item{continuous}{character, continuous transition for selected aesthethic ('size'
or 'color'('colour')). It should be one of 'color' (or 'colour'), 'size', 'all'
and 'none', default is 'none'}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function, default is "identity".}

\item{...}{additional parameter

some dot arguments:
\itemize{
\item \code{nsplit} integer, the number of branch blocks divided when 'continuous' is not "none", default is 200.
}}
}
\value{
tree layer
}
\description{
add tree layer
}
\section{Aesthetics}{

\code{geom_tree()} understands the following aesthethics:
\itemize{
\item \code{color} character, control the color of line, default is black (\code{continuous} is "none").
\item \code{linetype} control the type of line, default is 1 (solid).
\item \code{size} numeric, control the width of line, default is 0.5 (\code{continuous} is "none").
}
}

\examples{
tree <- rtree(10)
ggplot(tree) + geom_tree()
}
\references{
For demonstration of this function, please refer to chapter 4.2.1 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Yu Guangchuang
}
