% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep-tidy.R
\name{keep_tidy}
\alias{keep_tidy}
\alias{keep_glance}
\alias{keep_augment}
\title{Tidy, glance or augment an object keeping a trace of its origin}
\usage{
keep_tidy(x, ..., to.keep = c("call", "terms", "formula", "fixed", "random"))

keep_glance(x, ..., to.keep = c("call", "terms", "formula", "fixed", "random"))

keep_augment(
  x,
  ...,
  to.keep = c("call", "terms", "formula", "fixed", "random")
)
}
\arguments{
\item{x}{An object for which \code{tidy()}, \code{glance} and/or
\code{augment} method is available.}

\item{...}{Other named arguments passed along to \code{tidy()}, \code{glance}
or \code{augment}.}

\item{to.keep}{character vector of field names in \code{x} to copy to
attribute \code{"fm"} of the tibble returned by \code{tidy()},
\code{glance} or \code{augment}.}
}
\description{
Methods implemented in package 'broom' to tidy, glance and augment the output
from model fits return a consistently organized tibble with generic column
names. Although this simplifies later steps in the data analysis and
reporting, it drops key information needed for interpretation.
\code{keep_tidy()} makes it possible to retain fields from the model fit
object passed as argument to parameter \code{x} in the attribute \code{"fm"}.
The class of \code{x} is always stored, and by default also fields
\code{"call"}, \code{"terms"}, \code{"formula"}, \code{"fixed"} and
\code{"random"} if available.
}
\details{
Functions \code{keep_tidy()}, \code{keep_glance} or
  \code{keep_augment} are simple wrappers of the generic methods which make
  it possible to add to the returned values an attribute named \code{"fm"}
  preserving user selected fields and class of the model fit object. Fields
  names in \code{to.keep} missing in \code{x} are silently ignored.
}
\examples{

# these examples can only be run if package 'broom' is available

if (requireNamespace("broom", quietly = TRUE)) {

  library(broom)

  mod <- lm(mpg ~ wt + qsec, data = mtcars)

  attr(keep_tidy(mod), "fm")[["class"]]
  attr(keep_glance(mod), "fm")[["class"]]
  attr(keep_augment(mod), "fm")[["class"]]

  attr(keep_tidy(summary(mod)), "fm")[["class"]]

  library(MASS)
  rmod <- rlm(mpg ~ wt + qsec, data = mtcars)
  attr(keep_tidy(rmod), "fm")[["class"]]

}

}
