% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_1d.R
\name{method_norm_1d}
\alias{method_norm_1d}
\title{Univariate parametric normal HDR estimator}
\usage{
method_norm_1d()
}
\description{
Function used to specify univariate normal density estimator
for \code{get_hdr_1d()} and layer functions (e.g. \code{geom_hdr_rug()}).
}
\details{
For more details on the use and implementation of the \verb{method_*_1d()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
# Normal estimators are useful when an assumption of normality is appropriate
df <- data.frame(x = rnorm(1e3))

ggplot(df, aes(x)) +
  geom_hdr_rug(method = method_norm_1d()) +
  geom_density()

# Can also be used with `get_hdr_1d()` for numerical summary of HDRs
res <- get_hdr_1d(df$x, method = method_norm_1d())
str(res)

}
