% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderers.R
\name{sprite_file}
\alias{sprite_file}
\alias{print.sprite_image}
\alias{knit_print.sprite_image}
\title{Wrap an image sprite for easy handling}
\usage{
sprite_file(file, fps, width, full_width, height)

\method{print}{sprite_image}(x, width = NULL, ...)

knit_print.sprite_image(x, options, ...)
}
\arguments{
\item{file}{A png file with frames placed horizontally}

\item{fps}{The framerate for the sprite animation}

\item{width, height}{The dimension of a single frame}

\item{full_width}{The width of the whole image}

\item{x}{A \code{sprite_image} object}

\item{...}{Arguments passed on}
}
\value{
\code{sprite_file} returns a \code{sprite_image} object which is a shallow wrapper
around the file path text string along with dimensions and fps used for
animating the sprite when printing.
}
\description{
This function is equivalent to \code{\link[=gif_file]{gif_file()}} but works for animations encoded
as a sprite. A sprite is a single image file where each frame of the
animation is stacked next to each other. The animation then happens by
changing what slice of the image is shown. The implementation used allow
users to click on the animation in order to toggle pause/play.
}
\keyword{internal}
