% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_textpath.R
\name{guide_axis_textpath}
\alias{guide_axis_textpath}
\title{Textpath axis}
\usage{
guide_axis_textpath(
  title = waiver(),
  halign = "center",
  rich = FALSE,
  minor.ticks = FALSE,
  cap = "none",
  order = 0,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{halign}{A \code{character(1)} describing how multi-line text should be
justified. Can either be \code{"center"} (default), \code{"left"} or \code{"right"}.}

\item{rich}{A \code{logical(1)} whether to interpret the text as html/markdown
formatted rich text. Default: \code{FALSE}. See also the rich text section of
the details in \code{\link[=geom_textpath]{geom_textpath()}}.}

\item{minor.ticks}{Whether to draw the minor ticks (\code{TRUE}) or not draw
minor ticks (\code{FALSE}, default).}

\item{cap}{A \code{character} to cut the axis line back to the last breaks. Can
be \code{"none"} (default) to draw the axis line along the whole panel, or
\code{"upper"} and \code{"lower"} to draw the axis to the upper or lower break, or
\code{"both"} to only draw the line in between the most extreme breaks. \code{TRUE}
and \code{FALSE} are shorthand for \code{"both"} and \code{"none"} respectively.}

\item{order}{A positive \code{integer} of length 1 that specifies the order of
this guide among multiple guides. This controls in which order guides are
merged if there are multiple guides for the same position. If 0 (default),
the order is determined by a secret algorithm.}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
A \code{Guide} ggproto object that can be added to a plot through a
 scale or the \code{guides()} function.
}
\description{
This is a specialised guide used in \code{coord_radial()} to represent
the theta position scale.
}
\examples{
ggplot(mpg, aes(class, displ)) +
  geom_boxplot(staplewidth = 0.5) +
  coord_radial() +
  guides(theta = "axis_textpath")
}
