% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdalraster_proc.R
\name{read_ds}
\alias{read_ds}
\title{Convenience wrapper for \code{GDALRaster$read()}}
\usage{
read_ds(
  ds,
  bands = NULL,
  xoff = 0,
  yoff = 0,
  xsize = ds$getRasterXSize(),
  ysize = ds$getRasterYSize(),
  out_xsize = xsize,
  out_ysize = ysize
)
}
\arguments{
\item{ds}{An object of class \code{GDALRaster} in open state.}

\item{bands}{Integer vector of band numbers to read. By default all bands
will be read.}

\item{xoff}{Integer. The pixel (column) offset to the top left corner of the
raster region to be read (zero to start from the left side).}

\item{yoff}{Integer. The line (row) offset to the top left corner of the
raster region to be read (zero to start from the top).}

\item{xsize}{Integer. The width in pixels of the region to be read.}

\item{ysize}{Integer. The height in pixels of the region to be read.}

\item{out_xsize}{Integer. The width in pixels of the output buffer into
which the desired region will be read (e.g., to read a reduced resolution
overview).}

\item{out_ysize}{Integer. The height in pixels of the output buffer into
which the desired region will be read (e.g., to read a reduced resolution
overview).}
}
\value{
Returns a \code{numeric} or \code{complex} vector containing the values that
were read. It is organized in left to right, top to bottom pixel order,
interleaved by band.
\code{NA} will be returned in place of the nodata value if the raster dataset has
a nodata value defined for the band. Data are read as R \code{integer} type when
possible for the raster data type (Byte, Int8, Int16, UInt16, Int32),
otherwise as type \code{double} (UInt32, Float32, Float64).
}
\description{
\code{read_ds()} will read from a raster dataset that is already open in a
\code{GDALRaster} object. By default, it attempts to read the full raster
extent from all bands at full resolution. \code{read_ds()} is sometimes more
convenient than \code{GDALRaster$read()}, e.g., to read specific multiple bands
for display with \code{\link[=plot_raster]{plot_raster()}}, or simply for the argument defaults to
read an entire raster into memory (see Note).
}
\note{
There is small overhead in calling \code{read_ds()} compared with
calling \code{GDALRaster$read()} directly. This would only matter if calling
the function repeatedly to read a raster in chunks. For the case of reading
a large raster in many chunks, it will be optimal performance-wise to call
\code{GDALRaster$read()} directly.

By default, this function will attempt to read the full raster into memory.
It generally should not be called on large raster datasets using the default
argument values. The memory size in bytes of the returned vector will be
approximately (xsize * ysize * number of bands * 4) for data read as
\code{integer}, and (xsize * ysize * number of bands * 8) for data read as
\code{double} (plus small object overhead for the vector).
}
\examples{
# read three bands from a multi-band dataset
lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
ds <- new(GDALRaster, lcp_file, read_only=TRUE)

r <- read_ds(ds, bands=c(6,5,4))
typeof(r)
length(r)
object.size(r)

ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster$read()}}
}
