% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{copyDatasetFiles}
\alias{copyDatasetFiles}
\title{Copy the files of a dataset}
\usage{
copyDatasetFiles(new_filename, old_filename, format = "")
}
\arguments{
\item{new_filename}{New name for the dataset (copied to).}

\item{old_filename}{Old name for the dataset (copied from).}

\item{format}{Raster format short name (e.g., "GTiff"). If set to empty
string \code{""} (the default), will attempt to guess the raster format from
\code{old_filename}.}
}
\value{
Logical \code{TRUE} if no error or \code{FALSE} on failure.
}
\description{
\code{copyDatasetFiles()} copies all the files associated with a dataset.
Wrapper for \code{GDALCopyDatasetFiles()} in the GDAL API.
}
\note{
If \code{format} is set to an empty string \code{""} (the default) then the function
will try to identify the driver from \code{old_filename}. This is done
internally in GDAL by invoking the \code{Identify} method of each registered
\code{GDALDriver} in turn. The first driver that successful identifies the file
name will be returned. An error is raised if a format cannot be determined
from the passed file name.
}
\examples{
lcp_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
ds <- new(GDALRaster, lcp_file)
ds$getFileList()
ds$close()

lcp_tmp <- paste0(tempdir(), "/", "storm_lake_copy.lcp")
copyDatasetFiles(lcp_tmp, lcp_file)
ds_copy <- new(GDALRaster, lcp_tmp)
ds_copy$getFileList()
ds_copy$close()

deleteDataset(lcp_tmp)
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster-class}}, \code{\link[=create]{create()}}, \code{\link[=createCopy]{createCopy()}},
\code{\link[=deleteDataset]{deleteDataset()}}, \code{\link[=renameDataset]{renameDataset()}}, \code{\link[=vsi_copy_file]{vsi_copy_file()}}
}
