\name{boot_coef}
\alias{boot_coef}
\alias{boot_coef_one}

\title{
Plotting Bootstrap Coefficients 
}
\description{
The function \code{boot_coef()} plots in  one or multiple pages the results from a boostrap generated by the function  \code{BayesianBoot()}, \code{NonParamatricBoot} or \code{nonpar_boot().}

The function \code{boot_coef_one()} plots a single parameter. 

}
\usage{
boot_coef(x, terms = NULL, hist.col = "black", 
                hist.fill = "white", dens.fill = "#FF6666", 
                alpha = 0.2, nrow = NULL, ncol = NULL, 
                plots.per.page = 9, one.by.one = FALSE, title, ...)
                
boot_coef_one(x, par = 1, rug = TRUE, alpha = 0.2, hist.col = "black", 
                hist.fill = "white", line.col = "gray", 
                dens.fill = "#FF6666", title, ...)              
}
\arguments{
  \item{x}{a \code{Bayesian.boot} or \code{NonParametric.boot} object}
  \item{terms}{which terms to plot (default NULL means all terms}
  \item{par}{which parameter to plot}
  \item{hist.col}{colour of the  border histogram}
  \item{hist.fill}{the colour of the histogram}
  \item{dens.fill}{the colour of the density estimate}
  \item{alpha}{transparity constant}
  \item{nrow}{how namy rows}
  \item{ncol}{how many columns}
  \item{plots.per.page}{the maxiimum plots per page}
  \item{one.by.one}{whether single plots}
  \item{rug}{whether rug is required for \code{boot_coef_one()}}
   \item{line.col}{the vertical line colour  for \code{boot_coef_one()}}
  \item{title}{the title}
  \item{\dots}{for more argument}
}
\details{
The function plots in one ore multiple pages the results from a boostrap simulation}
\value{
Greates a ggplot object
}
\references{
Rigby, R. A. and  Stasinopoulos D. M. (2005). Generalized additive models for location, scale and shape,(with discussion), 
\emph{Appl. Statist.}, \bold{54}, part 3, pp 507-554.

Rigby, R. A., Stasinopoulos, D. M.,  Heller, G. Z.,  and De Bastiani, F. (2019)
	\emph{Distributions for modeling location, scale, and shape: Using GAMLSS in R}, Chapman and Hall/CRC. An older version can be found in \url{https://www.gamlss.com/}.

Stasinopoulos D. M. Rigby R.A. (2007) Generalized additive models for location scale and shape (GAMLSS) in R.
\emph{Journal of Statistical Software}, Vol. \bold{23}, Issue 7, Dec 2007, \url{https://www.jstatsoft.org/v23/i07/}.

Stasinopoulos D. M., Rigby R.A., Heller G., Voudouris V., and De Bastiani F., (2017)
\emph{Flexible Regression and Smoothing: Using GAMLSS in R},  Chapman and Hall/CRC.  

Stasinopoulos, M.D., Kneib, T., Klein, N., Mayr, A. and Heller, G.Z., (2024). \emph{Generalized Additive Models for Location, Scale and Shape: A Distributional Regression Approach, with Applications} (Vol. \bold{56}). Cambridge University Press.

(see also \url{https://www.gamlss.com/}).
}
\author{Mikis Stasinopoulos}

\seealso{
\code{\link[gamlss]{term.plot}}
}

\examples{
\donttest{
data(aids)
a <- gamlss(y ~ pb(x) + qrt, data = aids, family = NBI)
registerDoParallel(cores = 2)
B1 <- BayesianBoot(a, B=100)
stopImplicitCluster()
boot_coef(B1)
}
}

\keyword{regression}
