% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai_cluster.R
\name{mirai_cluster}
\alias{mirai_cluster}
\title{Mirai-based cluster futures}
\usage{
mirai_cluster(expr, substitute = TRUE, envir = parent.frame(), ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{...}{Additional named elements of the future.}
}
\value{
An object of class \link{MiraiFuture}.
}
\description{
Mirai-based cluster futures
}
\examples{
mirai::daemons(parallelly::availableCores(), dispatcher = FALSE)
plan(mirai_cluster)

# A function that returns a future, note that N uses lexical scoping...
f <- function() future({4 * sum((runif(N) ^ 2 + runif(N) ^ 2) < 1) / N}, seed = TRUE)

# Run a simple sampling approximation of pi in parallel using  M * N points:
N <- 1e6  # samples per worker
M <- 10   # iterations
pi_est <- Reduce(sum, Map(value, replicate(M, f()))) / M
print(pi_est)

plan(sequential)
invisible(mirai::daemons(0)) ## Shut down mirai workers
}
