# WARNING - Generated by {fusen} from dev/flat_inflate_all.Rmd: do not edit by hand

# unlink(dummypackage, recursive = TRUE)
dummypackage <- tempfile("inflateall.first")
dir.create(dummypackage)
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

# let's create a flat file
flat_file <- dev_file[grepl("flat_", dev_file)]

test_that("inflate_all is a function", {
  expect_true(inherits(inflate_all, "function"))
})

usethis::with_project(dummypackage, {
  # Add licence
  usethis::use_mit_license("John Doe")

  test_that("error if no config file exists", {
    # if no config file exists, we raise an error
    withr::with_options(list(cli.width = 80), {
      # cli.width is requires as cli output is wrapped to the console size
      expect_error(inflate_all(),
        regexp = "requires a configuration file to[[:space:]]work properly"
      )
    })
  })

  # we inflate the flat file
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE, document = TRUE,
      overwrite = "yes"
    )
  )
  config_yml_ref <- yaml::read_yaml(getOption("fusen.config_file", default = "dev/config_fusen.yaml"))

  test_that("inflate_all says which is going to be inflated", {
    expect_message(inflate_all(check = FALSE),
      regexp = glue::glue("The flat file {basename(flat_file)} is going to be inflated")
    )
  })

  test_that("deprecated is detected and not inflated", {
    # Let's deprecate our flat file
    config_yml_deprecated <- config_yml_ref
    config_yml_deprecated[["flat_minimal.Rmd"]][["state"]] <- "deprecated"
    config_yml_deprecated[["flat_minimal.Rmd"]][["R"]] <- ""
    write_yaml_verbatim(config_yml_deprecated, file = "dev/config_fusen.yaml")

    # And remove R file to verify it is not rebuilt
    fun_file <- file.path("R", "my_fun.R")
    expect_true(file.exists(fun_file))
    file.remove(fun_file)

    expect_message(inflate_all(check = FALSE),
      regexp = glue::glue("The flat file {basename(flat_file)} is not going to be inflated because it is in state 'inactive or deprecated'")
    )

    expect_false(file.exists(fun_file))
  })

  test_that("new flat file, absent from config_fusen.yml works", {
    # Let's add a new flat file, absent from config_fusen.yml
    flat_file2 <- gsub(x = flat_file, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
    file.copy(from = flat_file, to = flat_file2, overwrite = TRUE)

    expect_message(inflate_all(check = FALSE),
      regexp = glue::glue("The flat file flat_minimal_2.Rmd is not going to be inflated. It was detected in your flats directory but it is absent from the config file.")
    )

    unlink(flat_file2)
  })

  test_that("error when remove params", {
    # Let's remove the inflate parameters from config_fusen.yml
    config_yml_no_inflate_params <- config_yml_ref
    config_yml_no_inflate_params[["flat_minimal.Rmd"]][["inflate"]] <- NULL
    write_yaml_verbatim(config_yml_no_inflate_params, file = "dev/config_fusen.yaml")

    expect_error(inflate_all(check = FALSE), regexp = "The flat file flat_minimal[.]Rmd is not going to be inflated because although present in the config file, it has no inflate\\(\\) parameters")
  })

  test_that("flat file in config_fusen.yml not present in dev", {
    # Let's add a flat file in config_fusen.yml not present in dev/
    config_yml_file_absent_in_dev <- config_yml_ref
    config_yml_file_absent_in_dev[["missing_file.Rmd"]] <- config_yml_file_absent_in_dev[["flat_minimal.Rmd"]]
    config_yml_file_absent_in_dev[["missing_file.Rmd"]][["path"]] <- "dev/missing_file.Rmd"
    write_yaml_verbatim(config_yml_file_absent_in_dev, file = "dev/config_fusen.yaml")

    expect_error(inflate_all(check = FALSE), regexp = "The file missing_file[.]Rmd is not going to be inflated because it was not found")
  })

  test_that("inflate all really inflates all", {
    # Now let's take the ability of inflate_all() to inflate all our files !
    # We start from a clean place
    write_yaml_verbatim(config_yml_ref, file = "dev/config_fusen.yaml")

    suppressMessages(
      inflate(
        pkg = dummypackage, flat_file = flat_file,
        vignette_name = "Get started", check = FALSE,
        open_vignette = FALSE, document = TRUE,
        overwrite = "yes"
      )
    )
    # we delete the files created by inflate
    unlink(list.files(file.path(dummypackage, "R"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "man"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "tests/testthat"), full.names = TRUE))

    expect_false(file.exists(file.path(dummypackage, "R", "my_fun.R")))
    expect_false(file.exists(file.path(dummypackage, "man", "my_fun.Rd")))
    expect_false(file.exists(file.path(dummypackage, "tests/testthat", "test-my_fun.R")))

    inflate_all(check = FALSE)

    expect_true(file.exists(file.path(dummypackage, "R", "my_fun.R")))
    expect_true(file.exists(file.path(dummypackage, "man", "my_fun.Rd")))
    expect_true(file.exists(file.path(dummypackage, "tests/testthat", "test-my_fun.R")))
  })

  test_that("add a function in our flat file works", {
    # what happens if we add a function in our flat file
    flat_content <- readLines(flat_file)
    function_template <- readLines(system.file("inflate_all/fusen_chunk_template", package = "fusen"))

    writeLines(c(flat_content, function_template), con = flat_file)

    inflate_all(check = FALSE)

    expect_equal(
      list.files(file.path(dummypackage, "R/")),
      c("my_fun.R", "new_fun2.R")
    )

    expect_equal(
      list.files(file.path(dummypackage, "man/")),
      c("my_fun.Rd", "new_fun2.Rd")
    )

    expect_equal(
      list.files(file.path(dummypackage, "tests/testthat")),
      c("test-my_fun.R", "test-new_fun2.R")
    )
  })

  test_that("A second flat file works", {
    # let's add a second flat
    flat_file2 <- gsub(x = flat_file, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
    file.copy(from = flat_file, to = flat_file2, overwrite = TRUE)
    # let's change the function name in the flat_file2
    flat_file2_content <- readLines(flat_file2)
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "my_fun", replacement = "my_fun_from_flat_file2")
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "Minimal", replacement = "Minimal_2")
    writeLines(text = flat_file2_content, con = flat_file2)

    suppressMessages(
      inflate(
        pkg = dummypackage, flat_file = flat_file2,
        vignette_name = "Get started_2", check = FALSE,
        open_vignette = FALSE, document = TRUE,
        overwrite = "yes"
      )
    )

    # we delete the files created by inflate
    unlink(list.files(file.path(dummypackage, "R"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "man"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "tests/testthat"), full.names = TRUE))

    expect_true(length(list.files(file.path(dummypackage, "R"), full.names = TRUE)) == 0)
    expect_true(length(list.files(file.path(dummypackage, "man"), full.names = TRUE)) == 0)
    expect_true(length(list.files(file.path(dummypackage, "tests/testthat"), full.names = TRUE)) == 0)

    inflate_all(check = FALSE)

    expect_true(all(
      list.files(file.path(dummypackage, "R/")) %in% c("my_fun.R", "my_fun_from_flat_file2.R", "new_fun2.R")
    ))

    expect_true(all(
      list.files(file.path(dummypackage, "man/")) %in% c("my_fun.Rd", "my_fun_from_flat_file2.Rd", "new_fun2.Rd")
    ))

    expect_true(all(
      list.files(file.path(dummypackage, "tests/testthat")) %in% c(
        "test-my_fun.R",
        "test-my_fun_from_flat_file2.R",
        "test-new_fun2.R"
      )
    ))

    expect_true(all(
      list.files(file.path(dummypackage, "vignettes/")) %in% c("get-started.Rmd", "get-started_2.Rmd")
    ))

    unlink(list.files(file.path(dummypackage, "R"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "man"), full.names = TRUE))
    unlink(list.files(file.path(dummypackage, "tests/testthat"), full.names = TRUE))
    unlink(flat_file2)
  })

  test_that("inflate_all deals with vignette name", {
    write_yaml_verbatim(config_yml_ref, file = "dev/config_fusen.yaml")

    flat_file2 <- gsub(x = flat_file, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
    file.copy(from = flat_file, to = flat_file2, overwrite = TRUE)
    # let's change the function name in the flat_file2
    flat_file2_content <- readLines(flat_file2)
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "my_fun", replacement = "my_fun_from_flat_file2")
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "flat_minimal.Rmd", replacement = "flat_minimal_2.Rmd")
    flat_file2_content <- gsub(x = flat_file2_content, pattern = "Minimal", replacement = "Minimal_2")
    writeLines(text = flat_file2_content, con = flat_file2)

    # Let's check a other way to choose the vignette name
    suppressMessages(
      inflate(
        pkg = dummypackage, flat_file = flat_file2,
        vignette_name = c("name" = "index"), check = FALSE,
        open_vignette = FALSE, document = TRUE,
        overwrite = "yes"
      )
    )

    unlink(list.files(file.path(dummypackage, "vignettes"), full.names = TRUE))
    expect_true(length(list.files(file.path(dummypackage, "vignettes"), full.names = TRUE)) == 0)

    inflate_all(check = FALSE)

    expect_true(all(list.files(file.path(
      dummypackage, "vignettes/"
    )) %in% c("get-started.Rmd", "index.Rmd")))
  })
})

unlink(dummypackage, recursive = TRUE)

# with no files named flat_ works ----

# You can also inflate_all flats of another package as follows
# Example with a dummy package with a flat file
dummypackage <- tempfile("inflateall.other.pkg")
dir.create(dummypackage)
suppressMessages(fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package")))
flat_files <- add_minimal_package(
  pkg = dummypackage,
  overwrite = TRUE,
  open = FALSE
)
flat_file <- flat_files[grep("flat", basename(flat_files))]
# Change flat name
flat_file_newname <- gsub("flat_minimal[.]Rmd", "test_minimal.Rmd", flat_file)
file.rename(flat_file, flat_file_newname)

# Inflate the flat file once
usethis::with_project(dummypackage, {
  # Add licence
  suppressMessages(usethis::use_mit_license("John Doe"))

  # you need to inflate manually your flat file first
  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file_newname,
      vignette_name = "Get started",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
  )

  # your config file has been created
  config_yml_ref <-
    yaml::read_yaml(getOption("fusen.config_file", default = "dev/config_fusen.yaml"))

  test_that("inflate_all with no files named flat_ works", {
    # now you can run inflate_all()
    expect_message(
      inflate_all(check = FALSE, document = TRUE),
      regexp = "The flat file test_minimal.Rmd is going to be inflated"
    )

    # Delete R file and see if it comes back
    the_file <- file.path("R", "my_fun.R")
    file.remove(the_file)
    expect_false(file.exists(the_file))

    inflate_all(check = FALSE, document = TRUE)
    expect_true(file.exists(the_file))
  })
})

# Clean the temporary directory
unlink(dummypackage, recursive = TRUE)

# Test inflate_all_no_check vs inflate_all with check ----
dummypackage <- tempfile("inflateall.nocheck")
dir.create(dummypackage)
suppressMessages(fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package")))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

# let's create a flat file
flat_file <- dev_file[grepl("flat_", dev_file)]

test_that("inflate_all_no_check is a function", {
  expect_true(inherits(inflate_all_no_check, "function"))
})

usethis::with_project(dummypackage, {
  # Add licence
  suppressMessages(usethis::use_mit_license("John Doe"))

  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file,
      vignette_name = "toto",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
  )

  test_that("when check = FALSE we ensure no check has been performed", {
    # no check
    utils::capture.output(inflate_all_no_check(),
      file = file.path(dummypackage, "dev/inflate_all_nocheck.txt")
    )

    expect_false(any(grepl(
      pattern = "R CMD check",
      x = readLines(file.path(
        dummypackage, "dev/inflate_all_nocheck.txt"
      ))
    )))
  })

  test_that("rmdcheck does not raise errors on the created package", {
    check_out <- rcmdcheck::rcmdcheck(dummypackage,
      quiet = TRUE,
      args = c("--no-manual")
    )
    expect_true(length(check_out[["errors"]]) == 0)
  })

  # run check on interactive mode only
  test_that("inflate_all with check = TRUE works", {
    skip_if_not(interactive())
    suppressMessages(inflate_all(
      check = TRUE,
      quiet = TRUE,
      args = c("--no-manual", "--no-build-vignettes"),
      check_dir = file.path(dummypackage, "dev/")
    ))
    check_lines <- readLines(file.path(dummypackage, "dev/", paste0(basename(dummypackage), ".Rcheck"), "00check.log"))
    expect_equal(check_lines[length(check_lines)], "Status: OK")
  })
})

unlink(dummypackage, recursive = TRUE)

# Test inflate_all detects unregistered files ----
dummypackage <- tempfile("inflateall.unregistered")
dir.create(dummypackage)
suppressMessages(fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package")))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # Add licence
  suppressMessages(usethis::use_mit_license("John Doe"))

  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file,
      vignette_name = "toto",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
  )

  test_that("inflate_all detects unregistered files", {
    # Create an unregistered file
    cat("# unregistered file in R\n",
      file = file.path(dummypackage, "R", "unregistered_r.R")
    )
    cat("# unregistered file in test\n",
      file = file.path(dummypackage, "tests", "testthat", "test-unregistered_r.R")
    )

    expect_message(
      inflate_all_no_check(),
      regexp = "Some files in your package are not registered"
    )
    csv_file <- file.path("dev", "config_not_registered.csv")
    expect_true(file.exists(csv_file))

    csv_content <- read.csv(csv_file, stringsAsFactors = FALSE)
    csv_content <- csv_content[order(csv_content[["path"]]), ]

    csv_content_expected <- structure(
      list(
        type = c("R", "test"),
        path = c(
          "R/unregistered_r.R",
          "tests/testthat/test-unregistered_r.R"
        ),
        origin = c(
          "No existing source path found.",
          "No existing source path found."
        )
      ),
      row.names = 1:2,
      class = "data.frame"
    )
    csv_content_expected <- csv_content_expected[order(csv_content_expected[["path"]]), ]

    expect_equal(csv_content, csv_content_expected)

    config_content <- yaml::read_yaml(file.path(dummypackage, "dev", "config_fusen.yaml"))

    expect_true(
      !is.null(config_content[["flat_minimal.Rmd"]][["inflate"]])
    )
  })

  test_that("inflate_all is silent after files registered", {
    # register everything
    register_all_to_config()

    config_content <- yaml::read_yaml(file.path(dummypackage, "dev", "config_fusen.yaml"))

    expect_true(
      !is.null(config_content[["flat_minimal.Rmd"]][["inflate"]])
    )
    expect_equal(
      config_content[["keep"]][["R"]],
      "R/unregistered_r.R"
    )
    expect_equal(
      config_content[["keep"]][["tests"]],
      "tests/testthat/test-unregistered_r.R"
    )

    expect_message(
      inflate_all_no_check(),
      regexp = "There are no unregistered files"
    )
  })

  test_that("inflate_all is does not check registered if FALSE", {
    output <- capture.output(inflate_all_no_check(clean = FALSE))
    expect_false(any(grepl("registered", output)))
  })

  test_that("register_all_to_config does not affect inflate_all with autonomous files", {
    config_content <- yaml::read_yaml(file.path(dummypackage, "dev", "config_fusen.yaml"))
    # Imagine that R/my_fun.R was previously named R/my_old_name.R
    file.copy(
      file.path(dummypackage, "R", "my_fun.R"),
      file.path(dummypackage, "R", "my_old_name.R")
    )

    expect_message(
      inflate_all_no_check(),
      regexp = "Some files in your package are not registered"
    )

    # register everything
    suppressMessages(register_all_to_config())

    expect_message(
      inflate_all_no_check(),
      regexp = "There are no unregistered files"
    )
  })
})
unlink(dummypackage, recursive = TRUE)

# inflate_all can deal with empty flat files ----
dummypackage <- tempfile("inflate.empties")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # More complicated example for tests
  testfile <- "tests-templates/dev-template-text-only-no-output.Rmd"
  file.copy(
    system.file(testfile, package = "fusen"),
    flat_file,
    overwrite = TRUE
  )
  suppressMessages(usethis::use_mit_license("Statnmap"))

  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  test_that("empty flat - only vignette created during inflate", {
    expect_true(file.exists(file.path(dummypackage, "vignettes", "get-started.Rmd")))
    expect_false(dir.exists(file.path(dummypackage, "R")))
    expect_false(dir.exists(file.path(dummypackage, "tests")))
  })

  # empty flat is present in config file
  test_that("empty flat is present in config file", {
    config_content <- yaml::read_yaml(file.path(dummypackage, "dev", "config_fusen.yaml"))

    # present in config file
    expect_equal(names(config_content), "flat_full.Rmd")
    expect_equal(config_content[["flat_full.Rmd"]][["path"]], "dev/flat_full.Rmd")

    # no files listed expect vignette
    expect_equal(config_content[["flat_full.Rmd"]][["R"]], list())
    expect_equal(config_content[["flat_full.Rmd"]][["tests"]], list())
    expect_equal(config_content[["flat_full.Rmd"]][["vignettes"]], "vignettes/get-started.Rmd")

    # all params there
    expect_equal(
      names(config_content[["flat_full.Rmd"]][["inflate"]]),
      c(
        "flat_file", "vignette_name", "open_vignette",
        "check", "document", "overwrite"
      )
    )
  })

  # empty flat is going to be inflated
  test_that("empty flat is going to be inflated", {
    expect_message(
      inflate_all_no_check(),
      regexp = "The flat file flat_full.Rmd is going to be inflated"
    )
  })

  # Inflate with no vignette, nothing
  # Delete vignette
  file.remove(file.path(dummypackage, "vignettes", "get-started.Rmd"))
  file.remove(file.path(dummypackage, "dev", "config_fusen.yaml"))

  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = NA, check = FALSE,
      open_vignette = FALSE
    )
  )

  test_that("empty_flat - no vignette created during inflate", {
    expect_false(file.exists(file.path(dummypackage, "vignettes", "get-started.Rmd")))
    expect_false(dir.exists(file.path(dummypackage, "R")))
    expect_false(dir.exists(file.path(dummypackage, "tests")))
  })

  # flat_full is present in config file
  test_that("empty flat is present in config file", {
    config_content <- yaml::read_yaml(file.path(dummypackage, "dev", "config_fusen.yaml"))

    # present in config file
    expect_equal(names(config_content), "flat_full.Rmd")
    expect_equal(config_content[["flat_full.Rmd"]][["path"]], "dev/flat_full.Rmd")

    # no files listed expect vignette
    expect_equal(config_content[["flat_full.Rmd"]][["R"]], list())
    expect_equal(config_content[["flat_full.Rmd"]][["tests"]], list())
    expect_equal(config_content[["flat_full.Rmd"]][["vignettes"]], list())

    # all params there
    expect_equal(
      names(config_content[["flat_full.Rmd"]][["inflate"]]),
      c(
        "flat_file", "vignette_name", "open_vignette",
        "check", "document", "overwrite"
      )
    )
    expect_true(is.na(config_content[["flat_full.Rmd"]][["inflate"]][["vignette_name"]]))
  })

  # flat_full.Rmd is going to be inflated
  test_that("empty flat is going to be inflated", {
    expect_message(
      inflate_all_no_check(),
      regexp = "The flat file flat_full.Rmd is going to be inflated"
    )

    expect_false(file.exists(file.path(dummypackage, "vignettes", "get-started.Rmd")))
    expect_false(dir.exists(file.path(dummypackage, "R")))
    expect_false(dir.exists(file.path(dummypackage, "tests")))
  })
})
unlink(dummypackage, recursive = TRUE)

# Test inflate_all works with stylers ----
dummypackage <- tempfile("inflateall.stylers")
dir.create(dummypackage)
suppressMessages(fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package")))
dev_file <- suppressMessages(add_minimal_package(pkg = dummypackage, overwrite = TRUE, open = FALSE))

flat_file <- dev_file[grepl("flat_", dev_file)]

usethis::with_project(dummypackage, {
  # Add licence
  suppressMessages(usethis::use_mit_license("John Doe"))

  suppressMessages(
    inflate(
      pkg = dummypackage,
      flat_file = flat_file,
      vignette_name = "toto",
      check = FALSE,
      open_vignette = FALSE,
      document = TRUE,
      overwrite = "yes"
    )
  )

  # Check that stylers work ----
  test_that("stylers works in inflate_all", {
    # as character
    expect_message(
      inflate_all_no_check(stylers = "message('stylers ok')"),
      regexp = "stylers ok"
    )
    # as function
    expect_message(
      inflate_all_no_check(stylers = function() message("stylers ok")),
      regexp = "stylers ok"
    )
    # as other - run during `if()` call, but that's normal...
    expect_message(
      inflate_all_no_check(stylers = message("stylers ok")),
      regexp = "stylers ok"
    )
  })
})
