% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_fusen_files.R
\name{df_to_config}
\alias{df_to_config}
\title{Add a tibble of files and types to the 'fusen' config file}
\usage{
df_to_config(
  df_files,
  flat_file_path = "keep",
  state = c("active", "deprecated"),
  force = FALSE,
  clean = TRUE
)
}
\arguments{
\item{df_files}{A dataframe with 'type' and 'path' columns
or a csv file path as issued from \verb{[check_not_registered_files()]}
or nothing (and it will take the csv file in "dev/")}

\item{flat_file_path}{Character. Usually \code{"keep"} or the name of the origin flat file, although inflating the flat file should have the same result.}

\item{state}{Character. Whether if the flat file is \code{active} or \code{deprecated}.}

\item{force}{Logical. Whether to force writing the configuration file even is some files do not exist.}

\item{clean}{Logical. Delete list associated a specific flat file before updating the whole list. Default is set to TRUE during \code{inflate()} of a specific flat fil, as the list should only contain files created during the inflate. This parameter is set to FALSE with \code{register_to_config()} so that it can be run twice on the package when migrating from an old version of {fusen}. This could be set to FALSE with a direct use of \code{df_to_config()} too.}
}
\value{
Config file path.
Side effect: create a yaml config file.
}
\description{
Add a tibble of files and types to the 'fusen' config file
}
\details{
\itemize{
\item Only types: "R", "test", "vignette" are accepted.
\item All \code{path} should exist.
\item Change path to config file with \code{options(fusen.config_file = "dev/config_fusen.yaml")}
}
}
\examples{
# Add your own list of files to "keep",
# if they are not in a flat file.
# Otherwise, they may be deleted with your next `inflate()`
my_files_to_protect <- tibble::tribble(
  ~type, ~path,
  "R", "R/zaza.R",
  "R", "R/zozo.R",
  "test", "tests/testthat/test-zaza.R",
  "vignette", "vignettes/my-zaza-vignette.Rmd"
)

\dontrun{
df_to_config(my_files_to_protect)
}
}
