% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataMethods.R
\name{nObs}
\alias{nObs}
\title{Get the number of observations}
\usage{
nObs(object)
}
\arguments{
\item{object}{An object of class \code{funData}, \code{irregFunData} or \code{multiFunData}.}
}
\value{
The number of observations in \code{object}.
}
\description{
This functions returns the number of observations in a \code{funData}, \code{irregFunData} or \code{multiFunData} object.
}
\examples{
# Univariate
object <- funData(argvals = 1:5, X = rbind(1:5, 6:10))
nObs(object)

# Univariate (irregular)
irregObject <- irregFunData(argvals = list(1:5, 2:4), X = list(2:6, 3:5))
nObs(irregObject)

# Multivariate
multiObject <- multiFunData(object, funData(argvals = 1:3, X = rbind(3:5, 6:8)))
nObs(multiObject)
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{irregFunData}}, \code{\linkS4class{multiFunData}}
}
