% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header-transform.R
\name{separate_header}
\alias{separate_header}
\title{Separate the header based on delimiters}
\usage{
separate_header(x, sep = "[_\\\\.]", theme_fun = NULL, ...)
}
\arguments{
\item{x}{A \code{flextable} object`}

\item{sep}{Separator between columns.

If character, \code{sep} is interpreted as a regular expression. The default
value is a regular expression that matches any sequence of
non-alphanumeric values.

If numeric, \code{sep} is interpreted as character positions to split at. Positive
values start at 1 at the far-left of the string; negative value start at -1 at
the far-right of the string. The length of \code{sep} should be one less than
\code{into}.}

\item{theme_fun}{A flextable theme function.
When \code{NULL} (default), the value is resolved by
\code{flextable::get_flextable_defaults()}.}

\item{...}{Passed to \code{theme_fun}}
}
\description{
Separate the header based on delimiters
}
\examples{
iris \%>\%
  as_flextable() \%>\%
  separate_header()
}
