% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fplyr-package.R
\docType{package}
\name{fplyr-package}
\alias{fplyr}
\alias{fplyr-package}
\title{fplyr: Read, Process and Write}
\description{
This package provides a set of functions to quickly read files chunk by
chunk, apply a function to each chunk, and return the result. It is
especially useful when the files to be processed don't fit into the
RAM. Familiarity with the \code{data.table} package is essential in order
to use \code{fplyr}.
}
\section{Definitions}{

\describe{
\item{Chunked file:}{A delimited file where many contiguous rows have
the same value on the first field. See the example below.}
\item{Block:}{Any portion of the chunked file such that the first field
does not change.}
\item{Chunk:}{Chunks are used internally; they consist of one or more block, but
regular users should not be concerned with them, and can consider chunks
and blocks as synonyms.}
}
}

\section{Main functions}{

The main functions are \code{ffply} and \code{flply}. The former writes the processed
data into a file, while the latter returns it as a list. The former is also much faster.
There is also \code{fdply}, which returns a \code{data.table} and is useful to only read
a certain number of chunks from the file (one by default). \code{fmply} is useful
when the original file needs to be processed in many ways and each outcome must
be written to a different file.
}

\section{Note}{

Throughout the documentation of this package, the word 'file' actually means
'chunked file.'
}

\section{Examples}{

A chunked file may look as follows:\tabular{llll}{
   \strong{V1} \tab \strong{V2} \tab \strong{V3} \tab \strong{V4} \cr
   ID01 \tab ABC \tab Berlin \tab 0.1 \cr
   ID01 \tab DEF \tab London \tab 0.5 \cr
   ID01 \tab GHI \tab Rome \tab 0.3 \cr
   ID02 \tab ABC \tab Lisbon \tab 0.2 \cr
   ID02 \tab DEF \tab Berlin \tab 0.6 \cr
   ID02 \tab LMN \tab Prague \tab 0.8 \cr
   ID02 \tab OPQ \tab Dublin \tab 0.7 \cr
   ID03 \tab DEF \tab Lisbon \tab -0.1 \cr
   ID03 \tab LMN \tab Berlin \tab 0.01 \cr
   ID03 \tab XYZ \tab Prague \tab 0.2 \cr
}


The important thing is that the first field has some contiguous lines that
take the same value. The values of the other fields are unimportant. This
package is useful to process this kind of files, block by block.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/fmarotta/fplyr}
  \item Report bugs at \url{https://github.com/fmarotta/fplyr/issues}
}

}
\author{
\strong{Maintainer}: Federico Marotta \email{federico.marotta96@gmail.com} (\href{https://orcid.org/0000-0002-0174-3901}{ORCID})

}
\keyword{internal}
